/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.util.List;
import java.util.Map;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.ExternalResource;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CRLCertstore;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;

public class GestoreOCSPResource
implements IOCSPResourceReader {
    private OCSPConfig config;
    private RequestInfo requestInfo;
    private static final String OCSP_CONFIG_NULL = "OCSPConfig is null";

    public GestoreOCSPResource(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void initConfig(OCSPConfig config) throws UtilsException {
        this.config = config;
    }

    public KeyStore getIssuerAlternativeTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getAlternativeTrustStoreCAPath() != null) {
            try {
                return GestoreKeystoreCache.getMerlinTruststore(this.requestInfo, this.config.getAlternativeTrustStoreCAPath(), this.config.getAlternativeTrustStoreCAType(), this.config.getAlternativeTrustStoreCAPassword()).getTrustStore();
            }
            catch (Exception t) {
                throw new UtilsException(t.getMessage(), (Throwable)t);
            }
        }
        return null;
    }

    public void readExternalResource(String resource, Map<String, byte[]> holderResource) throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        try {
            ExternalResourceConfig externalConfig = new ExternalResourceConfig();
            externalConfig.setHostnameVerifier(this.config.isExternalResourcesHostnameVerifier());
            externalConfig.setTrustAllCerts(this.config.isExternalResourcesTrustAllCerts());
            if (this.config.getExternalResourcesTrustStorePath() != null) {
                try {
                    externalConfig.setTrustStore(GestoreKeystoreCache.getMerlinTruststore(this.requestInfo, this.config.getExternalResourcesTrustStorePath(), this.config.getExternalResourcesTrustStoreType(), this.config.getExternalResourcesTrustStorePassword()).getTrustStore().getKeystore());
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), (Throwable)t);
                }
            }
            if (this.config.getExternalResourcesKeyStorePath() != null) {
                try {
                    externalConfig.setKeyStore(GestoreKeystoreCache.getMerlinKeystore(this.requestInfo, this.config.getExternalResourcesKeyStorePath(), this.config.getExternalResourcesKeyStoreType(), this.config.getExternalResourcesKeyStorePassword()).getKeyStore().getKeystore());
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), (Throwable)t);
                }
                externalConfig.setKeyAlias(this.config.getExternalResourcesKeyAlias());
                externalConfig.setKeyPassword(this.config.getExternalResourcesKeyPassword());
            }
            if (this.config.getForwardProxyUrl() != null) {
                externalConfig.setForwardProxyUrl(this.config.getForwardProxyUrl());
                externalConfig.setForwardProxyHeader(this.config.getForwardProxyHeader());
                externalConfig.setForwardProxyQueryParameter(this.config.getForwardProxyQueryParameter());
                externalConfig.setForwardProxyBase64(this.config.isForwardProxyBase64());
            }
            externalConfig.setConnectTimeout(this.config.getConnectTimeout());
            externalConfig.setReadTimeout(this.config.getReadTimeout());
            externalConfig.setHttpLibrary(this.config.getHttpLibrary());
            ExternalResource externalResource = GestoreKeystoreCache.getExternalResource(this.requestInfo, resource, externalConfig);
            if (externalResource != null && externalResource.getId() != null) {
                holderResource.put(externalResource.getId(), externalResource.getResource());
            }
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), (Throwable)t);
        }
    }

    public CRLCertstore readCRL(List<String> crl, Map<String, byte[]> localResources) throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        try {
            return GestoreKeystoreCache.getCRLCertstore(this.requestInfo, CRLCertstore.convertToCrlPaths(crl), localResources).getWrappedCRLCertStore();
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), (Throwable)t);
        }
    }

    public KeyStore getSignerTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getTrustStoreSignerPath() != null) {
            try {
                return GestoreKeystoreCache.getMerlinTruststore(this.requestInfo, this.config.getTrustStoreSignerPath(), this.config.getTrustStoreSignerType(), this.config.getTrustStoreSignerPassword()).getTrustStore();
            }
            catch (Exception t) {
                throw new UtilsException(t.getMessage(), (Throwable)t);
            }
        }
        return null;
    }

    public KeyStore getHttpsTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getExternalResourcesTrustStorePath() != null) {
            try {
                return GestoreKeystoreCache.getMerlinTruststore(this.requestInfo, this.config.getExternalResourcesTrustStorePath(), this.config.getExternalResourcesTrustStoreType(), this.config.getExternalResourcesTrustStorePassword()).getTrustStore();
            }
            catch (Exception t) {
                throw new UtilsException(t.getMessage(), (Throwable)t);
            }
        }
        return null;
    }

    public KeyStore getHttpsKeyStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getExternalResourcesKeyStorePath() != null) {
            try {
                return GestoreKeystoreCache.getMerlinKeystore(this.requestInfo, this.config.getExternalResourcesKeyStorePath(), this.config.getExternalResourcesKeyStoreType(), this.config.getExternalResourcesKeyStorePassword()).getKeyStore();
            }
            catch (Exception t) {
                throw new UtilsException(t.getMessage(), (Throwable)t);
            }
        }
        return null;
    }

    public KeyStore getCrlAlternativeTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getAlternativeTrustStoreCRLPath() != null) {
            try {
                return GestoreKeystoreCache.getMerlinTruststore(this.requestInfo, this.config.getAlternativeTrustStoreCRLPath(), this.config.getAlternativeTrustStoreCRLType(), this.config.getAlternativeTrustStoreCRLPassword()).getTrustStore();
            }
            catch (Exception t) {
                throw new UtilsException(t.getMessage(), (Throwable)t);
            }
        }
        return null;
    }
}

