/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.util.List;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.HttpStore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.transport.http.HttpOptions;

public class HttpStoreCache
extends AbstractKeystoreCache<HttpStore> {
    @Override
    public HttpStore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        String endpoint = key;
        if (params.length == 0) {
            return new HttpStore(endpoint, new HttpOptions[0]);
        }
        if (params.length == 1) {
            if (!(params[0] instanceof MerlinTruststore || params[0] instanceof Boolean || params[0] instanceof HttpOptions[] || params[0] instanceof List)) {
                throw new SecurityException("Param[0] must be MerlinTruststore (trustStoreSsl) or Boolean (trustAll) or HttpOptions[] or List<HttpOptions>");
            }
            if (params[0] instanceof MerlinTruststore) {
                MerlinTruststore trustStoreSsl = (MerlinTruststore)params[0];
                return new HttpStore(endpoint, trustStoreSsl, new HttpOptions[0]);
            }
            if (params[0] instanceof Boolean) {
                Boolean trustAll = (Boolean)params[0];
                return new HttpStore(endpoint, trustAll, new HttpOptions[0]);
            }
            if (params[0] != null) {
                HttpOptions[] options = null;
                if (params[0] instanceof List) {
                    List l = (List)params[0];
                    if (!l.isEmpty()) {
                        options = new HttpOptions[1];
                        for (int i = 0; i < l.size(); ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof HttpOptions)) {
                                if (o == null) {
                                    throw new SecurityException("Param[0] with null element at position '" + i + "'");
                                }
                                throw new SecurityException("Param[0] with wrong type '" + o.getClass().getName() + "' at position '" + i + "'");
                            }
                            options[i] = (HttpOptions)o;
                        }
                    }
                } else {
                    options = (HttpOptions[])params[0];
                }
                return new HttpStore(endpoint, options);
            }
            return new HttpStore(endpoint, new HttpOptions[0]);
        }
        if (params.length == 2) {
            if (!(params[0] instanceof MerlinTruststore || params[0] instanceof Boolean || params[0] instanceof Integer)) {
                throw new SecurityException("Param[0] must be Integer (connectionTimeout) or MerlinTruststore (trustStoreSsl) or Boolean (trustAll)");
            }
            if (params[0] instanceof MerlinTruststore) {
                if (!(params[1] instanceof CRLCertstore) && !(params[1] instanceof HttpOptions[]) && params[1] != null) {
                    throw new SecurityException("Param[1] must be CRLCertstore (crlStoreSsl) or HttpOptions[]");
                }
                MerlinTruststore trustStoreSsl = (MerlinTruststore)params[0];
                if (params[1] instanceof CRLCertstore) {
                    CRLCertstore crlStoreSsl = (CRLCertstore)params[1];
                    return new HttpStore(endpoint, trustStoreSsl, crlStoreSsl, new HttpOptions[0]);
                }
                if (params[1] != null) {
                    HttpOptions[] options = (HttpOptions[])params[1];
                    return new HttpStore(endpoint, trustStoreSsl, options);
                }
                return new HttpStore(endpoint, trustStoreSsl, new HttpOptions[0]);
            }
            if (params[0] instanceof Boolean) {
                if (!(params[1] instanceof HttpOptions[]) && params[1] != null) {
                    throw new SecurityException("Param[1] must be HttpOptions[]");
                }
                Boolean trustAll = (Boolean)params[0];
                if (params[1] != null) {
                    HttpOptions[] options = (HttpOptions[])params[1];
                    return new HttpStore(endpoint, trustAll, options);
                }
                return new HttpStore(endpoint, trustAll, new HttpOptions[0]);
            }
            if (!(params[1] instanceof Integer)) {
                throw new SecurityException("Param[1] must be Integer (readTimeout)");
            }
            Integer connectionTimeout = (Integer)params[0];
            Integer readTimeout = (Integer)params[1];
            return new HttpStore(endpoint, connectionTimeout, readTimeout, new HttpOptions[0]);
        }
        if (params.length == 3) {
            if (!(params[0] instanceof Integer)) {
                throw new SecurityException("Param[0] must be Integer (connectionTimeout)");
            }
            if (!(params[1] instanceof Integer)) {
                throw new SecurityException("Param[1] must be Integer (readTimeout)");
            }
            if (!(params[2] instanceof MerlinTruststore || params[2] instanceof Boolean || params[2] instanceof HttpOptions[] || params[2] == null)) {
                throw new SecurityException("Param[2] must be MerlinTruststore (trustStoreSsl) or Boolean (trustAll) or HttpOptions[]");
            }
            Integer connectionTimeout = (Integer)params[0];
            Integer readTimeout = (Integer)params[1];
            if (params[2] instanceof MerlinTruststore) {
                MerlinTruststore trustStoreSsl = (MerlinTruststore)params[2];
                return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, new HttpOptions[0]);
            }
            if (params[2] instanceof Boolean) {
                Boolean trustAll = (Boolean)params[2];
                return new HttpStore(endpoint, connectionTimeout, readTimeout, trustAll, new HttpOptions[0]);
            }
            if (params[2] != null) {
                HttpOptions[] options = (HttpOptions[])params[2];
                return new HttpStore(endpoint, connectionTimeout, readTimeout, options);
            }
            return new HttpStore(endpoint, connectionTimeout, readTimeout, new HttpOptions[0]);
        }
        if (params.length == 4) {
            if (!(params[0] instanceof Integer)) {
                throw new SecurityException("Param[0] must be Integer (connectionTimeout)");
            }
            if (!(params[1] instanceof Integer)) {
                throw new SecurityException("Param[1] must be Integer (readTimeout)");
            }
            if (!(params[2] instanceof MerlinTruststore) && !(params[2] instanceof Boolean)) {
                throw new SecurityException("Param[2] must be MerlinTruststore (trustStoreSsl) or Boolean (trustAll)");
            }
            Integer connectionTimeout = (Integer)params[0];
            Integer readTimeout = (Integer)params[1];
            if (params[2] instanceof MerlinTruststore) {
                MerlinTruststore trustStoreSsl = (MerlinTruststore)params[2];
                if (!(params[3] instanceof CRLCertstore) && !(params[3] instanceof HttpOptions[]) && params[3] != null) {
                    throw new SecurityException("Param[3] must be CRLCertstore (crlStoreSsl) or HttpOptions[]");
                }
                if (params[3] instanceof CRLCertstore) {
                    CRLCertstore crlStoreSsl = (CRLCertstore)params[3];
                    return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, crlStoreSsl, new HttpOptions[0]);
                }
                if (params[3] != null) {
                    HttpOptions[] options = (HttpOptions[])params[3];
                    return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, options);
                }
                return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, new HttpOptions[0]);
            }
            Boolean trustAll = (Boolean)params[2];
            if (!(params[3] instanceof HttpOptions[]) && params[3] != null) {
                throw new SecurityException("Param[3] must be HttpOptions[]");
            }
            if (params[3] != null) {
                HttpOptions[] options = (HttpOptions[])params[3];
                return new HttpStore(endpoint, connectionTimeout, readTimeout, trustAll, options);
            }
            return new HttpStore(endpoint, connectionTimeout, readTimeout, trustAll, new HttpOptions[0]);
        }
        if (params.length == 5) {
            if (!(params[0] instanceof Integer)) {
                throw new SecurityException("Param[0] must be Integer (connectionTimeout)");
            }
            if (!(params[1] instanceof Integer)) {
                throw new SecurityException("Param[1] must be Integer (readTimeout)");
            }
            if (!(params[2] instanceof MerlinTruststore)) {
                throw new SecurityException("Param[2] must be MerlinTruststore (trustStoreSsl)");
            }
            if (!(params[3] instanceof CRLCertstore)) {
                throw new SecurityException("Param[3] must be CRLCertstore (crlStoreSsl)");
            }
            if (!(params[4] instanceof HttpOptions[]) && params[4] != null) {
                throw new SecurityException("Param[4] must be HttpOptions[]");
            }
            Integer connectionTimeout = (Integer)params[0];
            Integer readTimeout = (Integer)params[1];
            MerlinTruststore trustStoreSsl = (MerlinTruststore)params[2];
            CRLCertstore crlStoreSsl = (CRLCertstore)params[3];
            if (params[4] != null) {
                HttpOptions[] options = (HttpOptions[])params[4];
                return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, crlStoreSsl, options);
            }
            return new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, crlStoreSsl, new HttpOptions[0]);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "HttpStore ";
    }
}

