/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.constants;

import org.openspcoop2.generic_project.exception.NotFoundException;

public enum EncryptionSymmetricKeyWrapAlgorithm {
    TRIPLEDES("http://www.w3.org/2001/04/xmlenc#kw-tripledes"),
    AES_128("http://www.w3.org/2001/04/xmlenc#kw-aes128"),
    AES_256("http://www.w3.org/2001/04/xmlenc#kw-aes256"),
    AES_192("http://www.w3.org/2001/04/xmlenc#kw-aes192"),
    CAMELLIA_128("http://www.w3.org/2001/04/xmldsig-more#kw-camellia128"),
    CAMELLIA_192("http://www.w3.org/2001/04/xmldsig-more#kw-camellia192"),
    CAMELLIA_256("http://www.w3.org/2001/04/xmldsig-more#kw-camellia256"),
    SEED_128("http://www.w3.org/2007/05/xmldsig-more#kw-seed128");

    private String uri;

    private EncryptionSymmetricKeyWrapAlgorithm(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static EncryptionSymmetricKeyWrapAlgorithm toEnumConstant(String uri) {
        try {
            return EncryptionSymmetricKeyWrapAlgorithm.toEnumConstant(uri, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static EncryptionSymmetricKeyWrapAlgorithm toEnumConstant(String uri, boolean throwNotFoundException) throws NotFoundException {
        EncryptionSymmetricKeyWrapAlgorithm res = null;
        for (EncryptionSymmetricKeyWrapAlgorithm tmp : EncryptionSymmetricKeyWrapAlgorithm.values()) {
            if (!tmp.getUri().equals(uri)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with uri [" + uri + "] not found");
        }
        return res;
    }
}

