/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.net.Proxy;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKUnwrapManager;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.HttpStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.KeystoreUtils;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpForwardProxyConfig;
import org.openspcoop2.utils.transport.http.HttpForwardProxyOptions;
import org.openspcoop2.utils.transport.http.HttpOptions;
import org.openspcoop2.utils.transport.http.HttpProxyOptions;
import org.openspcoop2.utils.transport.http.HttpsOptions;
import org.slf4j.Logger;

public class JOSEUtils {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";

    private JOSEUtils() {
    }

    public static boolean isJoseContentType(OpenSPCoop2Message message) {
        if (message == null) {
            return false;
        }
        try {
            String contentType = message.getContentType();
            if (contentType == null || contentType.isEmpty()) {
                return false;
            }
            String baseType = ContentTypeUtilities.readBaseTypeFromContentType((String)contentType);
            if (baseType == null) {
                return false;
            }
            return "application/jwt".equalsIgnoreCase(baseType) || "application/jose".equalsIgnoreCase(baseType) || "application/jose+json".equalsIgnoreCase(baseType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JOSESerialization toJOSESerialization(String mode) throws SecurityException {
        if ("json".equals(mode)) {
            return JOSESerialization.JSON;
        }
        if ("compact".equals(mode)) {
            return JOSESerialization.COMPACT;
        }
        throw new SecurityException("Mode '" + mode + "' unsupported");
    }

    public static JwtHeaders getJwtHeaders(Map<String, Object> properties, OpenSPCoop2Message message) throws SecurityException {
        return JOSEUtils.getJwtHeaders(properties, message, null, null, null);
    }

    public static JwtHeaders getJwtHeaders(Map<String, Object> properties, OpenSPCoop2Message message, String alias) throws SecurityException {
        return JOSEUtils.getJwtHeaders(properties, message, alias, null, null);
    }

    public static JwtHeaders getJwtHeaders(Map<String, Object> properties, OpenSPCoop2Message message, String alias, JWKSet jwkSet) throws SecurityException {
        return JOSEUtils.getJwtHeaders(properties, message, alias, jwkSet, null);
    }

    public static JwtHeaders getJwtHeaders(Map<String, Object> properties, OpenSPCoop2Message message, String alias, KeyStore keystore) throws SecurityException {
        return JOSEUtils.getJwtHeaders(properties, message, alias, null, keystore);
    }

    private static JwtHeaders getJwtHeaders(Map<String, Object> properties, OpenSPCoop2Message message, String alias, JWKSet jwkSet, KeyStore keystore) throws SecurityException {
        String value;
        JwtHeaders hdrs = new JwtHeaders();
        if (properties.containsKey("joseKeyId")) {
            value = (String)properties.get("joseKeyId");
            if (value != null) {
                value = value.trim();
            }
            if ("true".equalsIgnoreCase(value)) {
                hdrs.setKid(alias);
            }
        } else if (properties.containsKey("joseKeyIdCustom") && (value = (String)properties.get("joseKeyIdCustom")) != null) {
            value = value.trim();
            hdrs.setKid(value);
        }
        if (properties.containsKey("joseIncludeCert")) {
            value = (String)properties.get("joseIncludeCert");
            if (value != null) {
                value = value.trim();
            }
            if ("true".equalsIgnoreCase(value)) {
                try {
                    if (alias == null) {
                        throw new SecurityException("Alias undefined (required for include cert)");
                    }
                    if (jwkSet != null) {
                        hdrs.setJwKey(jwkSet.getJsonWebKeys(), alias);
                    } else if (keystore != null) {
                        boolean certChain = false;
                        if (properties.containsKey("joseIncludeCertChain")) {
                            String valueChain = (String)properties.get("joseIncludeCertChain");
                            if (valueChain != null) {
                                valueChain = valueChain.trim();
                            }
                            if ("true".equalsIgnoreCase(valueChain)) {
                                certChain = true;
                            }
                        }
                        if (certChain) {
                            Certificate[] certificateChain = keystore.getCertificateChain(alias);
                            if (certificateChain != null && certificateChain.length > 0) {
                                for (int i = 0; i < certificateChain.length; ++i) {
                                    hdrs.addX509cert((X509Certificate)certificateChain[i]);
                                }
                            } else {
                                hdrs.addX509cert((X509Certificate)keystore.getCertificate(alias));
                            }
                        } else {
                            hdrs.addX509cert((X509Certificate)keystore.getCertificate(alias));
                        }
                        hdrs.setAddX5C(true);
                    }
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
        }
        if (properties.containsKey("joseIncludeCertSHA")) {
            value = (String)properties.get("joseIncludeCertSHA");
            if (value != null) {
                value = value.trim();
            }
            if (hdrs.getX509c() == null || hdrs.getX509c().isEmpty()) {
                if (keystore == null) {
                    throw new SecurityException("Keystore undefined (required for digest '" + value + "')");
                }
                if (alias == null) {
                    throw new SecurityException("Alias undefined (required for digest '" + value + "')");
                }
                Certificate cert = null;
                try {
                    cert = keystore.getCertificate(alias);
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
                if (cert == null) {
                    throw new SecurityException("Certificate with alias '" + alias + "' not found (required for digest '" + value + "')");
                }
                hdrs.addX509cert((X509Certificate)cert);
            }
            if ("sha1".equalsIgnoreCase(value)) {
                try {
                    hdrs.setX509IncludeCertSha1(true);
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            } else if ("sha256".equalsIgnoreCase(value)) {
                try {
                    hdrs.setX509IncludeCertSha256(true);
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            } else {
                throw new SecurityException("Value '" + value + "' unknowkn for property 'joseIncludeCertSHA'");
            }
        }
        if (properties.containsKey("joseContentType")) {
            value = (String)properties.get("joseContentType");
            if (value != null) {
                value = value.trim();
            }
            if ("true".equalsIgnoreCase(value)) {
                try {
                    hdrs.setContentType(message.getContentType());
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
        }
        if (properties.containsKey("joseType")) {
            value = (String)properties.get("joseType");
            if (value != null) {
                value = value.trim();
            }
            if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
                hdrs.setType(value);
            }
        }
        if (properties.containsKey("joseX509Url")) {
            value = (String)properties.get("joseX509Url");
            if (value != null) {
                value = value.trim();
            }
            if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
                try {
                    hdrs.setX509Url(new URI(value));
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
        }
        if (properties.containsKey("joseJWKSetUrl")) {
            value = (String)properties.get("joseJWKSetUrl");
            if (value != null) {
                value = value.trim();
            }
            if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
                try {
                    hdrs.setJwkUrl(new URI(value));
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
        }
        if (properties.containsKey("joseCriticalHeaders")) {
            value = (String)properties.get("joseCriticalHeaders");
            if (value != null) {
                value = value.trim();
            }
            if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
                if (value.contains(",")) {
                    String[] tmp;
                    for (String v : tmp = value.split(",")) {
                        if (v == null || StringUtils.isEmpty((CharSequence)(v = v.trim()))) continue;
                        hdrs.addCriticalHeader(v);
                    }
                } else {
                    hdrs.addCriticalHeader(value);
                }
            }
        }
        try {
            Properties pConvert = new Properties();
            pConvert.putAll(properties);
            Properties pExts = Utilities.readProperties((String)"joseExtensionHeader.", (Properties)pConvert);
            if (pExts != null && pExts.size() > 0) {
                Enumeration<?> names = pExts.propertyNames();
                while (names.hasMoreElements()) {
                    String name;
                    Object oName = names.nextElement();
                    if (!(oName instanceof String) || (name = (String)oName) == null || !(name = name.trim()).endsWith(".name")) continue;
                    String hdrName = pExts.getProperty(name);
                    String confName = name.substring(0, name.indexOf(".name"));
                    String nameValue = confName + ".value";
                    String hdrValue = pExts.getProperty(nameValue);
                    if (hdrValue == null) {
                        throw new SecurityException("Property 'joseExtensionHeader." + nameValue + "' not found");
                    }
                    hdrs.addExtension(hdrName, hdrValue);
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return hdrs;
    }

    public static boolean useJwtHeadersMapProperties(Map<String, Properties> properties, JWTOptions options) {
        Properties defaultProperties = MultiPropertiesUtilities.getDefaultProperties(properties);
        return JOSEUtils.useJwtHeaders(defaultProperties, options);
    }

    public static boolean useJwtHeadersMap(Map<String, Object> propertiesParam, JWTOptions options) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.useJwtHeaders(properties, options);
    }

    public static boolean useJwtHeaders(Properties properties, JWTOptions options) {
        boolean useJwtHeaders = false;
        if (properties.containsKey("joseUseHeaders")) {
            String value = (String)properties.get("joseUseHeaders");
            if (value != null) {
                value = value.trim();
                useJwtHeaders = "true".equalsIgnoreCase(value);
            }
            if (useJwtHeaders) {
                if (properties.containsKey("joseUseHeaders.x5c") && (value = (String)properties.get("joseUseHeaders.x5c")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderX5C("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.x5u") && (value = (String)properties.get("joseUseHeaders.x5u")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderX5U("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.x5t") && (value = (String)properties.get("joseUseHeaders.x5t")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderX5T("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.x5t256") && (value = (String)properties.get("joseUseHeaders.x5t256")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderX5T_256("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.jwk") && (value = (String)properties.get("joseUseHeaders.jwk")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderJWK("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.jku") && (value = (String)properties.get("joseUseHeaders.jku")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderJKU("true".equalsIgnoreCase(value));
                }
                if (properties.containsKey("joseUseHeaders.kid") && (value = (String)properties.get("joseUseHeaders.kid")) != null) {
                    value = value.trim();
                    options.setPermitUseHeaderKID("true".equalsIgnoreCase(value));
                }
            }
        }
        return useJwtHeaders;
    }

    public static Properties toSslConfigJwtUrlHeader(Map<String, Object> propertiesParam) {
        String keystoreFile;
        Properties properties = null;
        if (propertiesParam.containsKey("rs.security.keystore.file.ssl") && (keystoreFile = (String)propertiesParam.get("rs.security.keystore.file.ssl")) != null) {
            String keystorePassword;
            properties = new Properties();
            properties.put("rs.security.keystore.file.ssl", keystoreFile);
            String keystoreType = (String)propertiesParam.get("rs.security.keystore.type.ssl");
            if (keystoreType != null) {
                properties.put("rs.security.keystore.type.ssl", keystoreType);
            }
            if ((keystorePassword = (String)propertiesParam.get("rs.security.keystore.password.ssl")) != null) {
                properties.put("rs.security.keystore.password.ssl", keystorePassword);
            }
        }
        return properties;
    }

    public static KeyStore readTrustStoreSsl(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readTrustStoreSsl(requestInfo, properties);
    }

    public static KeyStore readTrustStoreSsl(RequestInfo requestInfo, Properties properties) throws SecurityException {
        return JOSEUtils.readTrustStoreEngine(requestInfo, properties, "rs.security.keystore.file.ssl", "rs.security.keystore.type.ssl", "rs.security.keystore.password.ssl");
    }

    public static KeyStore readTrustStoreJwtX509Cert(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readTrustStoreJwtX509Cert(requestInfo, properties);
    }

    public static KeyStore readTrustStoreJwtX509Cert(RequestInfo requestInfo, Properties properties) throws SecurityException {
        return JOSEUtils.readTrustStoreEngine(requestInfo, properties, "joseUseHeaders.truststore.file", "joseUseHeaders.truststore.type", "joseUseHeaders.truststore.password");
    }

    public static boolean isJWKSetTrustStore(Map<String, Object> propertiesParam) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.isJWKSetTrustStore(properties);
    }

    public static boolean isJWKSetTrustStore(Properties properties) {
        String truststoreType;
        if (properties.containsKey("joseUseHeaders.truststore.type") && (truststoreType = (String)properties.get("joseUseHeaders.truststore.type")) != null) {
            return SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(truststoreType);
        }
        return false;
    }

    public static JWKSet readTrustStoreJwtJsonWebKeysCert(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readTrustStoreJwtJsonWebKeysCert(requestInfo, properties);
    }

    public static JWKSet readTrustStoreJwtJsonWebKeysCert(RequestInfo requestInfo, Properties properties) throws SecurityException {
        if (properties.containsKey("joseUseHeaders.truststore.file")) {
            String truststoreFile = (String)properties.get("joseUseHeaders.truststore.file");
            if (truststoreFile == null) {
                throw new SecurityException("Truststore value in property 'joseUseHeaders.truststore.file' is null");
            }
            truststoreFile = truststoreFile.trim();
            try {
                return GestoreKeystoreCache.getJwkSetStore(requestInfo, truststoreFile).getJwkSet();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static boolean isPublicKeyTrustStore(Map<String, Object> propertiesParam) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.isPublicKeyTrustStore(properties);
    }

    public static boolean isPublicKeyTrustStore(Properties properties) {
        String truststoreType;
        if (properties.containsKey("joseUseHeaders.truststore.type") && (truststoreType = (String)properties.get("joseUseHeaders.truststore.type")) != null) {
            return SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(truststoreType);
        }
        return false;
    }

    public static JWKSet readTrustStorePublicKey(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readTrustStorePublicKey(requestInfo, properties);
    }

    public static JWKSet readTrustStorePublicKey(RequestInfo requestInfo, Properties properties) throws SecurityException {
        if (properties.containsKey("joseUseHeaders.truststore.file")) {
            String truststoreFile = (String)properties.get("joseUseHeaders.truststore.file");
            if (truststoreFile == null) {
                throw new SecurityException("Truststore value in property 'joseUseHeaders.truststore.file' is null");
            }
            truststoreFile = truststoreFile.trim();
            String truststoreAlgo = (String)properties.get("joseUseHeaders.truststore.file.algorithm");
            if (truststoreAlgo == null) {
                throw new SecurityException("Key algorithm value in property 'joseUseHeaders.truststore.file.algorithm' is null");
            }
            truststoreAlgo = truststoreAlgo.trim();
            try {
                return GestoreKeystoreCache.getPublicKeyStore(requestInfo, truststoreFile, truststoreAlgo).getJwkSet();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static boolean isRemoteStore(Map<String, Object> propertiesParam) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.isRemoteStore(properties);
    }

    public static boolean isRemoteStore(Properties properties) {
        try {
            IRemoteStoreProvider provider = null;
            if (properties.containsKey("joseUseHeaders.truststore.remoteStoreProvider")) {
                provider = (IRemoteStoreProvider)properties.get("joseUseHeaders.truststore.remoteStoreProvider");
            }
            RemoteKeyType keyType = null;
            if (properties.containsKey("joseUseHeaders.truststore.remoteStoreKeyType")) {
                keyType = (RemoteKeyType)properties.get("joseUseHeaders.truststore.remoteStoreKeyType");
            }
            RemoteStoreConfig config = null;
            if (properties.containsKey("joseUseHeaders.truststore.remoteStoreConfig")) {
                config = (RemoteStoreConfig)properties.get("joseUseHeaders.truststore.remoteStoreConfig");
            }
            return provider != null && keyType != null && config != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyPairKeystore(Map<String, Object> propertiesParam) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.isKeyPairKeystore(properties);
    }

    public static boolean isKeyPairKeystore(Properties properties) {
        String keystoreType;
        if (properties.containsKey("joseUseHeaders.keystore.type") && (keystoreType = (String)properties.get("joseUseHeaders.keystore.type")) != null) {
            return SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType);
        }
        return false;
    }

    public static boolean isJWKSetKeyStore(Map<String, Object> propertiesParam) {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.isJWKSetKeyStore(properties);
    }

    public static boolean isJWKSetKeyStore(Properties properties) {
        String truststoreType;
        if (properties.containsKey("joseUseHeaders.keystore.type") && (truststoreType = (String)properties.get("joseUseHeaders.keystore.type")) != null) {
            return SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(truststoreType);
        }
        return false;
    }

    public static JWKSet readKeyStoreJwtJsonWebKeysCert(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readKeyStoreJwtJsonWebKeysCert(requestInfo, properties);
    }

    public static JWKSet readKeyStoreJwtJsonWebKeysCert(RequestInfo requestInfo, Properties properties) throws SecurityException {
        if (properties.containsKey("joseUseHeaders.keystore.file")) {
            String keystoreFile = (String)properties.get("joseUseHeaders.keystore.file");
            if (keystoreFile == null) {
                throw new SecurityException("Keystore value in property 'joseUseHeaders.keystore.file' is null");
            }
            keystoreFile = keystoreFile.trim();
            try {
                return GestoreKeystoreCache.getJwkSetStore(requestInfo, keystoreFile).getJwkSet();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static KeyStore readKeyStoreJwtX509Cert(RequestInfo requestInfo, Map<String, Object> propertiesParam) throws SecurityException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readKeyStoreJwtX509Cert(requestInfo, properties);
    }

    public static KeyStore readKeyStoreJwtX509Cert(RequestInfo requestInfo, Properties properties) throws SecurityException {
        return JOSEUtils.readTrustStoreEngine(requestInfo, properties, "joseUseHeaders.keystore.file", "joseUseHeaders.keystore.type", "joseUseHeaders.keystore.password");
    }

    public static Map<String, String> covertToJwtX509CertMapAliasPassword(Map<String, Object> propertiesParam) throws SecurityException, UtilsException {
        Properties properties = new Properties();
        properties.putAll(propertiesParam);
        return JOSEUtils.readJwtX509CertMapAliasPassword(properties);
    }

    public static Map<String, String> readJwtX509CertMapAliasPassword(Properties properties) throws SecurityException, UtilsException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Properties pMap = Utilities.readProperties((String)"joseUseHeaders.key.", (Properties)properties);
            if (pMap != null && pMap.size() > 0) {
                Enumeration<?> names = pMap.propertyNames();
                while (names.hasMoreElements()) {
                    Object oName = names.nextElement();
                    if (!(oName instanceof String)) continue;
                    String name = (String)oName;
                    if (!(name = name.trim()).endsWith(".alias")) continue;
                    String alias = pMap.getProperty(name);
                    String confName = name.substring(0, name.indexOf(".alias"));
                    String namePassword = confName + ".password";
                    String password = pMap.getProperty(namePassword);
                    if (password == null) {
                        throw new SecurityException("Property 'joseUseHeaders.key." + namePassword + "' not found");
                    }
                    map.put(alias, password);
                }
            }
            if (!map.isEmpty()) {
                return map;
            }
            return null;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private static KeyStore readTrustStoreEngine(RequestInfo requestInfo, Properties properties, String file, String type, String password) throws SecurityException {
        String keystoreFile;
        KeyStore keystore = null;
        String requiredPropertyPrefix = "Required property '";
        if (properties.containsKey(file) && (keystoreFile = (String)properties.get(file)) != null) {
            String keystorePassword;
            keystoreFile = keystoreFile.trim();
            if (!properties.containsKey(type)) {
                throw new SecurityException(requiredPropertyPrefix + type + "' not found");
            }
            String keystoreType = (String)properties.get(type);
            if (keystoreType == null) {
                throw new SecurityException(requiredPropertyPrefix + type + "' is empty");
            }
            keystoreType = keystoreType.trim();
            boolean requiredPassword = true;
            if (!properties.containsKey(password)) {
                if (KeystoreType.JKS.isType(keystoreType) && !DBUtils.isTruststoreJksPasswordRequired() || KeystoreType.PKCS12.isType(keystoreType) && !DBUtils.isTruststorePkcs12PasswordRequired()) {
                    requiredPassword = false;
                }
                if (requiredPassword) {
                    throw new SecurityException(requiredPropertyPrefix + password + "' not found");
                }
            }
            if ((keystorePassword = (String)properties.get(password)) == null && requiredPassword) {
                throw new SecurityException(requiredPropertyPrefix + password + "' is empty");
            }
            if (keystorePassword != null) {
                keystorePassword = keystorePassword.trim();
            }
            keystore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, keystoreFile, keystoreType, keystorePassword).getTrustStore();
        }
        return keystore;
    }

    public static void injectKeystore(RequestInfo requestInfo, Map<String, Object> dynamicMap, Properties properties, Logger log) {
        try {
            JOSEUtils.injectKeystore(requestInfo, dynamicMap, properties, log, false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void injectKeystore(RequestInfo requestInfo, Map<String, Object> dynamicMap, Properties properties, Logger log, boolean throwError) throws SecurityException {
        if (log == null) {
            log = LoggerWrapperFactory.getLogger(JOSEUtils.class);
        }
        if (properties != null && properties.containsKey("rs.security.keystore.file")) {
            block59: {
                file = properties.getProperty("rs.security.keystore.file");
                type = properties.getProperty("rs.security.keystore.type");
                if (type == null) {
                    type = SecurityConstants.KEYSTORE_TYPE_JKS_VALUE;
                }
                passwordDefined = (password = properties.getProperty("rs.security.keystore.password")) != null && "".equals(password) == false;
                byokPropertyName = "rs.security.keystore.file.byok";
                byokProperty = properties.getProperty(byokPropertyName);
                byokParams = null;
                byokManager = null;
                if (BYOKProvider.isPolicyDefined((String)byokProperty)) {
                    try {
                        byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)byokProperty, (Map)(dynamicMap != null ? dynamicMap : new HashMap<K, V>()));
                        byokManager = new BYOKUnwrapManager(byokProperty, byokParams);
                    }
                    catch (Exception e) {
                        error = "Errore durante istanziazione del byok unwrap manager '" + byokProperty + "': " + e.getMessage();
                        log.error(error, (Throwable)e);
                        if (!throwError) break block59;
                        throw new SecurityException(error, e);
                    }
                }
            }
            if (file != null && !"".equals(file)) {
                if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type)) {
                    privateKeyPassword = properties.getProperty("rs.security.key.password");
                    signatureAlgo = properties.getProperty("rs.security.signature.algorithm");
                    if (signatureAlgo == null || StringUtils.isEmpty((CharSequence)signatureAlgo)) {
                        signatureAlgo = properties.getProperty("signatureAlgorithm");
                    }
                    algorithmProperty = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm(signatureAlgo);
                    algorithmPropertyName = "rs.security.keystore.file.algorithm";
                    if (algorithmProperty == null) {
                        algorithmProperty = properties.getProperty(algorithmPropertyName);
                    }
                    if ((publicKeyProperty = properties.getProperty(publicKeyPropertyName = "rs.security.keystore.file.public")) == null || "".equals(publicKeyProperty)) {
                        error = "Errore durante l'accesso al keyPair '" + file + "': property public key file (" + publicKeyPropertyName + ") undefined";
                        log.error(error);
                        if (throwError) {
                            throw new SecurityException(error);
                        }
                    } else {
                        block60: {
                            keyPair = null;
                            if (file.startsWith("http") || file.startsWith("https")) {
                                privateKey = JOSEUtils.readHttpStore(properties, requestInfo, file, log, throwError);
                                publicKey = null;
                                if (publicKeyProperty.startsWith("http") || publicKeyProperty.startsWith("https")) {
                                    publicKey = JOSEUtils.readHttpStore(properties, requestInfo, publicKeyProperty, log, throwError);
                                } else {
                                    error = "Errore durante l'accesso al keyPair '" + file + "': property public key file (" + publicKeyPropertyName + ") expected as http resource: '" + publicKeyProperty + "'";
                                    log.error(error);
                                    if (throwError) {
                                        throw new SecurityException(error);
                                    }
                                }
                                try {
                                    keyPair = new KeyPairStore(privateKey, publicKey, privateKeyPassword, algorithmProperty, byokParams);
                                }
                                catch (Exception e) {
                                    error = "Errore durante istanziazione del keyPair (http resource) '" + file + "'/'" + publicKeyProperty + "': " + e.getMessage();
                                    log.error(error, (Throwable)e);
                                    if (!throwError) ** GOTO lbl67
                                    throw new SecurityException(error, e);
                                }
                            } else {
                                try {
                                    keyPair = GestoreKeystoreCache.getKeyPairStore(requestInfo, file, publicKeyProperty, privateKeyPassword, algorithmProperty, byokParams);
                                }
                                catch (Exception e) {
                                    error = "Errore durante istanziazione del keyPair '" + file + "'/'" + publicKeyProperty + "': " + e.getMessage();
                                    log.error(error, (Throwable)e);
                                    if (!throwError) break block60;
                                    throw new SecurityException(error, e);
                                }
                            }
                        }
                        if (keyPair != null) {
                            try {
                                jwkSet = keyPair.getJwkSet().getJson();
                                jwkSetKid = keyPair.getJwkSetKid();
                                properties.remove("rs.security.keystore.file");
                                properties.remove("rs.security.keystore.password");
                                properties.remove(algorithmPropertyName);
                                properties.remove(publicKeyPropertyName);
                                properties.remove("rs.security.key.password");
                                properties.remove("rs.security.keystore.alias");
                                properties.remove("rs.security.keystore.type");
                                properties.put("rs.security.keystore.jwkset", jwkSet);
                                properties.put("rs.security.keystore.alias", jwkSetKid);
                                properties.put("rs.security.keystore.type", SecurityConstants.KEYSTORE_TYPE_JWK_VALUE);
                            }
                            catch (Exception e) {
                                error = "Errore durante istanziazione del keyPair '" + file + "'/'" + publicKeyProperty + "': " + e.getMessage();
                                log.error(error, (Throwable)e);
                                if (!throwError) ** GOTO lbl235
                                throw new SecurityException(error, e);
                            }
                        }
                    }
                } else if (SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(type)) {
                    block61: {
                        algorithmPropertyName = "rs.security.keystore.file.algorithm";
                        algorithmProperty = properties.getProperty(algorithmPropertyName);
                        publicKeyStore = null;
                        if (file.startsWith("http") || file.startsWith("https")) {
                            publicKey = JOSEUtils.readHttpStore(properties, requestInfo, file, log, throwError);
                            try {
                                publicKeyStore = new PublicKeyStore(publicKey, algorithmProperty);
                            }
                            catch (Exception e) {
                                error = "Errore durante istanziazione della chiave pubblica (http resource) '" + file + "': " + e.getMessage();
                                log.error(error, (Throwable)e);
                                if (!throwError) ** GOTO lbl121
                                throw new SecurityException(error, e);
                            }
                        } else {
                            try {
                                publicKeyStore = GestoreKeystoreCache.getPublicKeyStore(requestInfo, file, algorithmProperty);
                            }
                            catch (Exception e) {
                                error = "Errore durante istanziazione della chiave pubblica '" + file + "': " + e.getMessage();
                                log.error(error, (Throwable)e);
                                if (!throwError) break block61;
                                throw new SecurityException(error, e);
                            }
                        }
                    }
                    if (publicKeyStore != null) {
                        try {
                            jwkSet = publicKeyStore.getJwkSet().getJson();
                            jwkSetKid = publicKeyStore.getJwkSetKid();
                            properties.remove("rs.security.keystore.file");
                            properties.remove("rs.security.keystore.password");
                            properties.remove(algorithmPropertyName);
                            properties.remove("rs.security.key.password");
                            properties.remove("rs.security.keystore.alias");
                            properties.remove("rs.security.keystore.type");
                            properties.put("rs.security.keystore.jwkset", jwkSet);
                            properties.put("rs.security.keystore.alias", jwkSetKid);
                            properties.put("rs.security.keystore.type", SecurityConstants.KEYSTORE_TYPE_JWK_VALUE);
                        }
                        catch (Exception e) {
                            error = "Errore durante istanziazione della chiave pubblica '" + file + "': " + e.getMessage();
                            log.error(error, (Throwable)e);
                            if (!throwError) ** GOTO lbl235
                            throw new SecurityException(error, e);
                        }
                    }
                } else if (passwordDefined != false || DBUtils.isKeystoreJksPasswordRequired() == false && SecurityConstants.KEYSTORE_TYPE_JKS_VALUE.equalsIgnoreCase(type) != false || DBUtils.isKeystorePkcs12PasswordRequired() == false && SecurityConstants.KEYSTORE_TYPE_PKCS12_VALUE.equalsIgnoreCase(type) != false || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(type)) {
                    if (file.startsWith("http") || file.startsWith("https")) {
                        block62: {
                            content = JOSEUtils.readHttpStore(properties, requestInfo, file, log, throwError);
                            if (byokManager != null) {
                                try {
                                    content = byokManager.unwrap(content);
                                }
                                catch (Exception e) {
                                    error = "Errore durante l'unwrap del keystore ottenuto via http '" + file + "': " + e.getMessage();
                                    log.error(error, (Throwable)e);
                                    if (!throwError) break block62;
                                    throw new SecurityException(error, e);
                                }
                            }
                        }
                        if (content != null) {
                            if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(type)) {
                                properties.remove("rs.security.keystore.file");
                                properties.remove("rs.security.keystore.password");
                                properties.put("rs.security.keystore.jwkset", new String(content));
                            } else {
                                block63: {
                                    keystore = null;
                                    try {
                                        keystore = KeystoreUtils.readKeystore((byte[])content, (String)type, (String)password);
                                    }
                                    catch (Exception e) {
                                        error = "Errore durante istanziazione del keystore ottenuto via http '" + file + "': " + e.getMessage();
                                        log.error(error, (Throwable)e);
                                        keystore = null;
                                        if (!throwError) break block63;
                                        throw new SecurityException(error, e);
                                    }
                                }
                                if (keystore != null) {
                                    properties.remove("rs.security.keystore.file");
                                    properties.remove("rs.security.keystore.password");
                                    properties.put("rs.security.keystore", keystore);
                                }
                            }
                        }
                    } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(type)) {
                        block64: {
                            jwkSet = null;
                            try {
                                jwkSet = GestoreKeystoreCache.getJwkSetStore(requestInfo, file, byokParams).getJwkSetContent();
                            }
                            catch (Exception e) {
                                error = "Errore durante l'accesso al jwk set '" + file + "': " + e.getMessage();
                                log.error(error, (Throwable)e);
                                if (!throwError) break block64;
                                throw new SecurityException(error, e);
                            }
                        }
                        if (jwkSet != null) {
                            properties.remove("rs.security.keystore.file");
                            properties.remove("rs.security.keystore.password");
                            properties.put("rs.security.keystore.jwkset", jwkSet);
                        }
                    } else {
                        block65: {
                            keystore = null;
                            try {
                                merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, file, type, password, byokParams);
                                if (merlinKeystore == null) {
                                    throw new SecurityException("Keystore '" + file + "' undefined");
                                }
                                keystoreUtils = merlinKeystore.getKeyStore();
                                if (keystoreUtils == null) {
                                    throw new SecurityException("Keystore '" + file + "' undefined");
                                }
                                keystore = keystoreUtils.getKeystore();
                            }
                            catch (Exception e) {
                                error = "Errore durante l'accesso al keystore '" + file + "': " + e.getMessage();
                                log.error(error, (Throwable)e);
                                if (!throwError) break block65;
                                throw new SecurityException(error, e);
                            }
                        }
                        if (keystore != null) {
                            properties.remove("rs.security.keystore.file");
                            properties.remove("rs.security.keystore.password");
                            properties.put("rs.security.keystore", keystore);
                        }
                    }
                }
            }
        }
lbl235:
        // 19 sources

    }

    public static byte[] readHttpStore(Properties properties, RequestInfo requestInfo, String file, Logger log, boolean throwError) throws SecurityException {
        return JOSEUtils.readHttpStore(properties, requestInfo, file, log, throwError, false);
    }

    public static byte[] readHttpStore(Properties properties, RequestInfo requestInfo, String file, Logger log, boolean throwError, boolean forceNoCache) throws SecurityException {
        byte[] content;
        block32: {
            content = null;
            try {
                String proxyType;
                String forwardProxyEndpoint;
                boolean trustAll = false;
                String trustStoreAllSslProperty = properties.getProperty("rs.security.keystore.trustAll.ssl");
                trustAll = trustStoreAllSslProperty != null && "true".equalsIgnoreCase(trustStoreAllSslProperty);
                String trustStoreSslPropertyName = "rs.security.keystore.file.ssl";
                String trustStoreSslProperty = properties.getProperty(trustStoreSslPropertyName);
                MerlinTruststore trustStoreSsl = null;
                if (trustStoreSslProperty != null) {
                    String trustStoreSslPasswordPropertyName = "rs.security.keystore.password.ssl";
                    String trustStoreSslTypePropertyName = "rs.security.keystore.type.ssl";
                    String trustStoreSslPasswordProperty = properties.getProperty(trustStoreSslPasswordPropertyName);
                    String trustStoreSslTypeProperty = properties.getProperty(trustStoreSslTypePropertyName);
                    if (trustStoreSslTypeProperty == null) {
                        throw new SecurityException("TrustStore ssl type undefined");
                    }
                    if (trustStoreSslPasswordProperty == null) {
                        boolean required = true;
                        if (KeystoreType.JKS.isType(trustStoreSslTypeProperty)) {
                            required = DBUtils.isTruststoreJksPasswordRequired();
                        } else if (KeystoreType.PKCS12.isType(trustStoreSslTypeProperty)) {
                            required = DBUtils.isTruststorePkcs12PasswordRequired();
                        }
                        if (required) {
                            throw new SecurityException("TrustStore ssl password undefined");
                        }
                    }
                    trustStoreSsl = GestoreKeystoreCache.getMerlinTruststore(requestInfo, trustStoreSslProperty, trustStoreSslTypeProperty, trustStoreSslPasswordProperty);
                }
                String trustStoreSslCrlPropertyName = "rs.security.keystore.ssl.crl";
                String trustStoreSslCrlProperty = properties.getProperty(trustStoreSslCrlPropertyName);
                CRLCertstore crlStore = null;
                if (trustStoreSslCrlProperty != null) {
                    crlStore = GestoreKeystoreCache.getCRLCertstore(requestInfo, trustStoreSslCrlProperty);
                }
                String trustStoreSslConnectionTimeoutPropertyName = "rs.security.keystore.ssl.connectionTimeout";
                String trustStoreSslReadTimeoutPropertyName = "rs.security.keystore.ssl.readTimeout";
                String trustStoreSslConnectionTimeoutProperty = properties.getProperty(trustStoreSslConnectionTimeoutPropertyName);
                String trustStoreSslReadTimeoutProperty = properties.getProperty(trustStoreSslReadTimeoutPropertyName);
                Integer connectionTimeout = null;
                Integer readTimeout = null;
                if (trustStoreSslConnectionTimeoutProperty != null && trustStoreSslReadTimeoutProperty != null) {
                    connectionTimeout = Integer.valueOf(trustStoreSslConnectionTimeoutProperty);
                    readTimeout = Integer.valueOf(trustStoreSslReadTimeoutProperty);
                }
                ArrayList<Object> list = new ArrayList<Object>();
                String trustStoreSslHostnameVerifier = properties.getProperty("rs.security.keystore.ssl.hostNameVerifier");
                if (trustStoreSslHostnameVerifier != null && StringUtils.isNotEmpty((CharSequence)trustStoreSslHostnameVerifier)) {
                    HttpsOptions op = new HttpsOptions();
                    op.setHostnameVerifier("true".equals(trustStoreSslHostnameVerifier));
                    list.add(op);
                }
                if ((forwardProxyEndpoint = properties.getProperty("rs.security.forwardProxy.endpoint")) != null && StringUtils.isNotEmpty((CharSequence)forwardProxyEndpoint)) {
                    HttpForwardProxyOptions op = new HttpForwardProxyOptions();
                    op.setForwardProxyEndpoint(forwardProxyEndpoint);
                    HttpForwardProxyConfig c = new HttpForwardProxyConfig();
                    String forwardProxyHeader = properties.getProperty("rs.security.forwardProxy.header");
                    String forwardProxyQuery = properties.getProperty("rs.security.forwardProxy.query");
                    if (forwardProxyHeader != null && StringUtils.isNotEmpty((CharSequence)forwardProxyHeader)) {
                        c.setHeader(forwardProxyHeader);
                        String forwardProxyHeaderBase64 = properties.getProperty("rs.security.forwardProxy.header.base64");
                        if (forwardProxyHeaderBase64 != null && StringUtils.isNotEmpty((CharSequence)forwardProxyHeaderBase64)) {
                            c.setHeaderBase64("false".equals(forwardProxyHeaderBase64));
                        }
                    } else if (forwardProxyQuery != null && StringUtils.isNotEmpty((CharSequence)forwardProxyQuery)) {
                        c.setQuery(forwardProxyQuery);
                        String forwardProxyQueryBase64 = properties.getProperty("rs.security.forwardProxy.query.base64");
                        if (forwardProxyQueryBase64 != null && StringUtils.isNotEmpty((CharSequence)forwardProxyQueryBase64)) {
                            c.setQueryBase64("false".equals(forwardProxyQueryBase64));
                        }
                    } else {
                        throw new SecurityException("ForwardProxy header o query required");
                    }
                    op.setForwardProxyConfig(c);
                    list.add(op);
                }
                if ((proxyType = properties.getProperty("rs.security.proxy.type")) != null && StringUtils.isNotEmpty((CharSequence)proxyType)) {
                    HttpProxyOptions op = new HttpProxyOptions();
                    if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP.equals(proxyType)) {
                        op.setProxyType(Proxy.Type.HTTP);
                    } else if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS.equals(proxyType)) {
                        op.setProxyType(Proxy.Type.HTTP);
                    } else {
                        throw new SecurityException("Proxy type '" + proxyType + "' unsupported");
                    }
                    String proxyHostname = properties.getProperty("rs.security.proxy.hostname");
                    if (proxyHostname == null || !StringUtils.isNotEmpty((CharSequence)proxyHostname)) {
                        throw new SecurityException("Proxy hostname undefined");
                    }
                    op.setProxyHostname(proxyHostname);
                    String proxyPort = properties.getProperty("rs.security.proxy.hostname");
                    if (proxyPort != null && StringUtils.isNotEmpty((CharSequence)proxyPort)) {
                        try {
                            op.setProxyPort(Integer.valueOf(proxyPort).intValue());
                        }
                        catch (Exception e) {
                            throw new SecurityException("Proxy port '" + proxyPort + "' invalid: " + e.getMessage());
                        }
                    } else {
                        throw new SecurityException("Proxy port undefined");
                    }
                    String proxyUsername = properties.getProperty("rs.security.proxy.username");
                    if (proxyUsername != null && StringUtils.isNotEmpty((CharSequence)proxyUsername)) {
                        op.setProxyUsername(proxyUsername);
                        String proxyPassword = properties.getProperty("rs.security.proxy.username");
                        if (proxyPassword != null) {
                            op.setProxyPassword(proxyPassword);
                        }
                    }
                    list.add(op);
                }
                HttpOptions[] options = null;
                if (!list.isEmpty()) {
                    options = list.toArray(new HttpOptions[1]);
                }
                content = forceNoCache ? (connectionTimeout != null && readTimeout != null ? (trustStoreSsl != null ? (crlStore != null ? new HttpStore(file, connectionTimeout, readTimeout, trustStoreSsl, crlStore, options).getStoreBytes() : new HttpStore(file, connectionTimeout, readTimeout, trustStoreSsl, options).getStoreBytes()) : (trustAll ? new HttpStore(file, connectionTimeout, readTimeout, (Boolean)trustAll, options).getStoreBytes() : new HttpStore(file, connectionTimeout, readTimeout, options).getStoreBytes())) : (trustStoreSsl != null ? (crlStore != null ? new HttpStore(file, trustStoreSsl, crlStore, options).getStoreBytes() : new HttpStore(file, trustStoreSsl, options).getStoreBytes()) : (trustAll ? new HttpStore(file, trustAll, options).getStoreBytes() : new HttpStore(file, options).getStoreBytes()))) : (connectionTimeout != null && readTimeout != null ? (trustStoreSsl != null ? (crlStore != null ? GestoreKeystoreCache.getHttpStore(requestInfo, file, connectionTimeout, readTimeout, trustStoreSsl, crlStore, options).getStoreBytes() : GestoreKeystoreCache.getHttpStore(requestInfo, file, connectionTimeout, readTimeout, trustStoreSsl, options).getStoreBytes()) : (trustAll ? GestoreKeystoreCache.getHttpStore(requestInfo, file, connectionTimeout, readTimeout, trustAll, options).getStoreBytes() : GestoreKeystoreCache.getHttpStore(requestInfo, file, connectionTimeout, readTimeout, options).getStoreBytes())) : (trustStoreSsl != null ? (crlStore != null ? GestoreKeystoreCache.getHttpStore(requestInfo, file, trustStoreSsl, crlStore, options).getStoreBytes() : GestoreKeystoreCache.getHttpStore(requestInfo, file, trustStoreSsl, options).getStoreBytes()) : (trustAll ? GestoreKeystoreCache.getHttpStore(requestInfo, file, trustAll, options).getStoreBytes() : GestoreKeystoreCache.getHttpStore(requestInfo, file, options).getStoreBytes())));
            }
            catch (Exception e) {
                String error = "Errore durante l'accesso al keystore via http '" + file + "': " + e.getMessage();
                log.error(error, (Throwable)e);
                if (!throwError) break block32;
                throw new SecurityException(error, e);
            }
        }
        return content;
    }
}

