/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.saml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.saml.bean.Version;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.message.saml.SAMLBuilderConfigAttribute;
import org.openspcoop2.security.message.saml.SAMLUtilities;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.KeystoreType;

public class SAMLBuilderConfig {
    private static Map<String, SAMLBuilderConfig> samlCacheConfig = new ConcurrentHashMap<String, SAMLBuilderConfig>();
    private static Semaphore semaphore = new Semaphore("SAMLBuilderConfig");
    private static final String SAML_CONFIG_BUILD_PROPERTY_PREFIX = "SAML Config Builder: property [";
    private static final String SAML_CONFIG_BUILD_REQUIRED_PROPERTY_PREFIX = "SAML Config Builder: required property [";
    private static final String SAML_CONFIG_BUILD_PROPERTY_OR = "] or [";
    private static final String SAML_CONFIG_BUILD_PROPERTY_IF_USE = "] if use property [";
    private RequestInfo requestInfo;
    private Properties p;
    private boolean useKeystoreCache = false;
    private Version version = null;
    private String issuerValue;
    private String issuerQualifier;
    private String issuerFormat;
    private boolean signAssertion = false;
    private Crypto signAssertionCrypto = null;
    private String signAssertionCryptoPropFile = null;
    private String signAssertionCryptoPropRefId = null;
    private String signAssertionCryptoPropCustomKeystoreType = null;
    private String signAssertionCryptoPropCustomKeystoreFile = null;
    private String signAssertionCryptoPropCustomKeystoreBYOKPolicy = null;
    private String signAssertionCryptoPropCustomKeystorePassword = null;
    private String signAssertionIssuerKeyPassword = null;
    private String signAssertionIssuerKeyName = null;
    private boolean signAssertionSendKeyValue = false;
    private String signAssertionSignatureAlgorithm;
    private String signAssertionSignatureDigestAlgorithm;
    private String signAssertionCanonicalizationAlgorithm;
    private boolean subjectEnabled = true;
    private String subjectNameIDValue;
    private String subjectNameIDQualifier;
    private String subjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    private String subjectConfirmationMethod = null;
    private int subjectConfirmationDataNotBefore = 0;
    private int subjectConfirmationDataNotOnOrAfter = 60;
    private String subjectConfirmationDataAddress;
    private String subjectConfirmationDataInResponseTo;
    private String subjectConfirmationDataRecipient;
    private Crypto subjectConfirmationMethodHolderOfKeyCrypto = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesFile = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesRefId = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreType = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreBYOKPolicy = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystorePassword = null;
    private String subjectConfirmationMethodHolderOfKeyCryptoCertificateAlias = null;
    private boolean conditionsEnabled = true;
    private int conditionsDataNotBefore = 0;
    private int conditionsDataNotOnOrAfter = 60;
    private String conditionsAudienceURI = null;
    private boolean authnStatementEnabled = true;
    private int authnStatementDataInstant = 0;
    private Date authnStatementDataInstantDate = null;
    private int authnStatementDataNotOnOrAfter = 60;
    private Date authnStatementDataNotOnOrAfterDate = null;
    private String authnStatementClassRef;
    private String authnStatementDeclRef;
    private String authnSubjectLocalityIpAddress;
    private String authnSubjectLocalityDnsAddress;
    private List<SAMLBuilderConfigAttribute> attributes = new ArrayList<SAMLBuilderConfigAttribute>();

    private static void addSamlConfig(String propertiesName, SAMLBuilderConfig p) {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("addSamlConfig");
        try {
            if (!samlCacheConfig.containsKey(propertiesName)) {
                samlCacheConfig.put(propertiesName, p);
            }
        }
        finally {
            semaphore.release(lock, "addSamlConfig");
        }
    }

    public static SAMLBuilderConfig getSamlConfig(String properties, RequestInfo requestInfo) throws IOException {
        InputStream is = null;
        try {
            File f = new File(properties);
            is = f.exists() ? new FileInputStream(f) : SAMLBuilderConfig.class.getResourceAsStream("/" + properties);
            if (is == null) {
                throw new IOException("SAMLPropFile [" + properties + "]: not found");
            }
            try {
                SAMLBuilderConfig sAMLBuilderConfig = SAMLBuilderConfig.getSamlConfig(Utilities.getAsProperties((InputStream)is), requestInfo);
                return sAMLBuilderConfig;
            }
            catch (Exception e) {
                throw new IOException("SAMLPropFile [" + properties + "]: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static SAMLBuilderConfig getSamlConfig(Properties p, RequestInfo requestInfoParam) throws IOException {
        boolean cacheConfig;
        String propertiesName = p.getProperty("openspcoop2.saml.config.name");
        if (propertiesName != null) {
            propertiesName = propertiesName.trim();
        }
        if ((cacheConfig = SAMLBuilderConfig.isTrue(p, "openspcoop2.saml.cached", false)) && propertiesName == null) {
            throw new IOException("SAML Config Builder: property [openspcoop2.saml.config.name] not found");
        }
        RequestInfo requestInfo = null;
        if (!cacheConfig) {
            requestInfo = requestInfoParam;
        }
        if (cacheConfig && samlCacheConfig.containsKey(propertiesName)) {
            return samlCacheConfig.get(propertiesName);
        }
        try {
            SAMLBuilderConfig config = new SAMLBuilderConfig(p, requestInfo);
            if (cacheConfig) {
                SAMLBuilderConfig.addSamlConfig(propertiesName, config);
            }
            return config;
        }
        catch (Exception e) {
            throw new IOException("Properties config [" + propertiesName + "]: " + e.getMessage(), e);
        }
    }

    private static boolean isTrue(Properties p, String name, boolean defaultValue) throws IOException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            try {
                return Boolean.parseBoolean(tmp.trim());
            }
            catch (Exception e) {
                throw new IOException("SAML Config Builder: boolean property [" + name + "] with wrong format: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    private static Integer getIntProperty(Properties p, String name, boolean required) throws IOException {
        String tmp = SAMLBuilderConfig.getProperty(p, name, required);
        if (tmp != null) {
            try {
                return Integer.parseInt(tmp);
            }
            catch (Exception e) {
                throw new IOException("SAML Config Builder: integer property [" + name + "] with wrong format: " + e.getMessage());
            }
        }
        return null;
    }

    private static String getProperty(Properties p, String name, boolean required) throws IOException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new IOException(SAML_CONFIG_BUILD_PROPERTY_PREFIX + name + "] not found");
        }
        return null;
    }

    public SAMLBuilderConfig(Properties p, RequestInfo requestInfo) throws IOException {
        SimpleDateFormat sdf;
        String format;
        this.p = p;
        this.requestInfo = requestInfo;
        this.useKeystoreCache = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.keystoreCache", false);
        boolean saml2 = false;
        String versionP = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.version", true);
        if ("1.0".equals(versionP)) {
            this.version = Version.SAML_10;
        } else if ("1.1".equals(versionP)) {
            this.version = Version.SAML_11;
        } else if ("2.0".equals(versionP)) {
            this.version = Version.SAML_20;
            saml2 = true;
        } else {
            throw new IOException("SAML Config Builder: property [openspcoop2.saml.version] not supported");
        }
        this.issuerValue = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.value", true);
        this.issuerQualifier = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.qualifier", false);
        String tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.format", false);
        if (tmp != null) {
            this.issuerFormat = this.getNameIDFormat(tmp);
        }
        this.signAssertion = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.assertion.sign", false);
        if (this.signAssertion) {
            this.signAssertionCryptoPropFile = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.file", false);
            this.signAssertionCryptoPropRefId = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.refId", false);
            this.signAssertionCryptoPropCustomKeystoreType = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.keystore.type", false);
            this.signAssertionCryptoPropCustomKeystoreFile = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.keystore.file", false);
            this.signAssertionCryptoPropCustomKeystoreBYOKPolicy = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.keystore.file.byok", false);
            this.signAssertionCryptoPropCustomKeystorePassword = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.keystore.password", false);
            if (this.signAssertionCryptoPropFile == null && this.signAssertionCryptoPropRefId == null && this.signAssertionCryptoPropCustomKeystoreFile == null) {
                throw new IOException("SAML Config Builder: required property [openspcoop2.saml.assertion.sign.cryptoProp.file] or [openspcoop2.saml.assertion.sign.cryptoProp.refId] or [openspcoop2.saml.assertion.sign.cryptoProp.keystore.file]");
            }
            if (this.signAssertionCryptoPropCustomKeystoreFile != null && this.signAssertionCryptoPropCustomKeystorePassword == null) {
                boolean required = true;
                if (KeystoreType.JKS.isType(this.signAssertionCryptoPropCustomKeystoreType)) {
                    required = DBUtils.isKeystoreJksPasswordRequired();
                } else if (KeystoreType.PKCS12.isType(this.signAssertionCryptoPropCustomKeystoreType)) {
                    required = DBUtils.isKeystorePkcs12PasswordRequired();
                }
                if (required) {
                    throw new IOException("SAML Config Builder: required property [openspcoop2.saml.assertion.sign.cryptoProp.keystore.password] if use property [openspcoop2.saml.assertion.sign.cryptoProp.keystore.file]");
                }
            }
            this.signAssertionIssuerKeyName = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.key.name", true);
            boolean requiredKey = true;
            if (KeystoreType.JKS.isType(this.signAssertionCryptoPropCustomKeystoreType)) {
                requiredKey = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(this.signAssertionCryptoPropCustomKeystoreType)) {
                requiredKey = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            this.signAssertionIssuerKeyPassword = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.key.password", requiredKey);
            this.signAssertionSendKeyValue = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.assertion.sign.sendKeyValue", false);
            this.signAssertionSignatureAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.signatureAlgorithm", false);
            this.signAssertionSignatureDigestAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.signatureDigestAlgorithm", false);
            this.signAssertionCanonicalizationAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.canonicalizationAlgorithm", false);
        }
        this.subjectNameIDValue = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.value", true);
        this.subjectNameIDQualifier = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.qualifier", false);
        tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.format", false);
        if (tmp != null) {
            this.subjectNameIDFormat = this.getNameIDFormat(tmp);
        }
        tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method", true);
        this.subjectConfirmationMethod = this.getSubjectConfirmationMethod(tmp, saml2);
        boolean holderOfKey = this.isHolderOfKeySubjectConfirmationMethod(this.subjectConfirmationMethod);
        Integer tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.subject.confirmation.data.notBefore.minutes", false);
        if (tmpInt != null) {
            this.subjectConfirmationDataNotBefore = tmpInt;
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.subject.confirmation.data.notOnOrAfter.minutes", false)) != null) {
            this.subjectConfirmationDataNotOnOrAfter = tmpInt;
        }
        this.subjectConfirmationDataAddress = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.address", false);
        this.subjectConfirmationDataInResponseTo = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.inResponseTo", false);
        this.subjectConfirmationDataRecipient = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.recipient", false);
        if (holderOfKey) {
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesFile = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties", false);
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesRefId = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.refId", false);
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreType = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.type", false);
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file", false);
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreBYOKPolicy = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file.byok", false);
            this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystorePassword = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.password", false);
            if (this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesFile == null && this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesRefId == null && this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile == null) {
                throw new IOException("SAML Config Builder: required property [openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties] or [openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.refId] or [openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file]");
            }
            if (this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile != null && this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystorePassword == null) {
                boolean required = true;
                if (KeystoreType.JKS.isType(this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreType)) {
                    required = DBUtils.isKeystoreJksKeyPasswordRequired();
                } else if (KeystoreType.PKCS12.isType(this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreType)) {
                    required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
                }
                if (required) {
                    throw new IOException("SAML Config Builder: required property [openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.password] if use property [openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file]");
                }
            }
            this.subjectConfirmationMethodHolderOfKeyCryptoCertificateAlias = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoCertificateAlias", true);
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.conditions.notBefore.minutes", false)) != null) {
            this.conditionsDataNotBefore = tmpInt;
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.conditions.notOnOrAfter.minutes", false)) != null) {
            this.conditionsDataNotOnOrAfter = tmpInt;
        }
        this.conditionsAudienceURI = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.conditions.audienceURI", false);
        this.authnStatementEnabled = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.authn.statement.enabled", true);
        tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.authn.statement.instant.minutes", false);
        if (tmpInt != null) {
            this.authnStatementDataInstant = tmpInt;
        }
        if ((tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.statement.instant.minutes.value", false)) != null) {
            String value = tmp;
            tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.statement.instant.minutes.format", false);
            if (tmp != null) {
                format = tmp;
                sdf = new SimpleDateFormat(format);
                try {
                    this.authnStatementDataInstantDate = sdf.parse(value);
                }
                catch (Exception e) {
                    throw new IOException("SAML Config Builder: failed parsing property value [openspcoop2.saml.authn.statement.instant.minutes.value=" + value + "] with format [openspcoop2.saml.authn.statement.instant.minutes.format=" + format + "]: " + e.getMessage(), e);
                }
            } else {
                throw new IOException("SAML Config Builder: required property [openspcoop2.saml.authn.statement.instant.minutes.format] if use property [openspcoop2.saml.authn.statement.instant.minutes.value]");
            }
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.authn.statement.notOnOrAfter.minutes", false)) != null) {
            this.authnStatementDataNotOnOrAfter = tmpInt;
        }
        if ((tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.statement.notOnOrAfter.minutes.value", false)) != null) {
            String value = tmp;
            tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.statement.notOnOrAfter.minutes.format", false);
            if (tmp != null) {
                format = tmp;
                sdf = new SimpleDateFormat(format);
                try {
                    this.authnStatementDataNotOnOrAfterDate = sdf.parse(value);
                }
                catch (Exception e) {
                    throw new IOException("SAML Config Builder: failed parsing property value [openspcoop2.saml.authn.statement.notOnOrAfter.minutes.value=" + value + "] with format [openspcoop2.saml.authn.statement.notOnOrAfter.minutes.format=" + format + "]: " + e.getMessage(), e);
                }
            } else {
                throw new IOException("SAML Config Builder: required property [openspcoop2.saml.authn.statement.notOnOrAfter.minutes.format] if use property [openspcoop2.saml.authn.statement.notOnOrAfter.minutes.value]");
            }
        }
        if ((tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn", this.authnStatementEnabled)) != null) {
            this.authnStatementClassRef = this.getAuthStatementMethod(tmp, saml2);
        }
        if ((tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.declRef", false)) != null) {
            this.authnStatementDeclRef = tmp.trim();
        }
        this.authnSubjectLocalityIpAddress = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.subjectLocality.ipAddress", false);
        this.authnSubjectLocalityDnsAddress = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn.subjectLocality.dnsAddress", false);
        Properties pAttribute = null;
        try {
            pAttribute = Utilities.readProperties((String)"openspcoop2.saml.attribute.statement.", (Properties)this.p);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        if (pAttribute != null && p.size() > 0) {
            ArrayList<String> attrNames = new ArrayList<String>();
            Enumeration<Object> enAttributes = pAttribute.keys();
            if (enAttributes != null) {
                while (enAttributes.hasMoreElements()) {
                    String key;
                    Object objectName = enAttributes.nextElement();
                    if (!(objectName instanceof String) || !(key = (String)objectName).endsWith(".values")) continue;
                    String attrName = key.substring(0, key.indexOf(".values"));
                    attrNames.add(attrName);
                }
            }
            Collections.sort(attrNames);
            for (String attrName : attrNames) {
                String values;
                String valuesTmp;
                String[] splitValues;
                SAMLBuilderConfigAttribute attr = new SAMLBuilderConfigAttribute(attrName);
                String qualifiedName = attrName + ".name.qualified";
                String simpleName = attrName + ".name.simple";
                String qualifiedNameTmp = SAMLBuilderConfig.getProperty(pAttribute, qualifiedName, !saml2);
                String simpleNameTmp = SAMLBuilderConfig.getProperty(pAttribute, simpleName, !saml2);
                if (qualifiedNameTmp == null && simpleNameTmp == null) {
                    throw new IOException("SAML Config Builder: attribute [" + attrName + "] requires at least one of the following properties: " + qualifiedName + ", " + simpleName);
                }
                attr.setQualifiedName(qualifiedNameTmp);
                attr.setSimpleName(simpleNameTmp);
                String format2 = attrName + ".name.format";
                if (saml2) {
                    formatTmp = SAMLBuilderConfig.getProperty(pAttribute, format2, true);
                    attr.setFormatName(this.getAttributeFormat(formatTmp));
                } else {
                    formatTmp = SAMLBuilderConfig.getProperty(pAttribute, format2, false);
                    if (formatTmp != null) {
                        throw new IOException("SAML Config Builder: name format unsupported in SAML 1.1; found in attribute [" + attrName + "]");
                    }
                }
                String separator = attrName + ".values.separator";
                String separatorTmp = SAMLBuilderConfig.getProperty(pAttribute, separator, false);
                if (separatorTmp == null || "".equals(separatorTmp)) {
                    separatorTmp = ",";
                }
                if ((splitValues = (valuesTmp = SAMLBuilderConfig.getProperty(pAttribute, values = attrName + ".values", true)).split(separatorTmp)) == null || splitValues.length <= 0) {
                    throw new IOException("SAML Config Builder: values not found in attribute [" + attrName + "] using separator [" + valuesTmp + "]");
                }
                for (int i = 0; i < splitValues.length; ++i) {
                    attr.addValue(splitValues[i].trim());
                }
                this.attributes.add(attr);
            }
        }
    }

    private String getNameIDFormat(String tmpParam) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        } else if ("EMAIL".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        } else if ("X509_SUBJECT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
        } else if ("WIN_DOMAIN_QUALIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";
        } else if ("KERBEROS".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
        } else if ("ENTITY".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        } else if ("PERSISTENT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
        } else if ("TRANSIENT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
        } else if ("ENCRYPTED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
        }
        return tmp;
    }

    private String getSubjectConfirmationMethod(String tmpParam, boolean saml2) {
        String tmp = tmpParam.trim();
        if ("ARTIFACT".equals(tmp) && !saml2) {
            tmp = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
        } else if ("IDENTITY".equals(tmp) && !saml2) {
            tmp = "urn:com:sun:identity";
        } else if ("BEARER".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:bearer" : "urn:oasis:names:tc:SAML:1.0:cm:bearer";
        } else if ("HOLDER_OF_KEY".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key" : "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        } else if ("SENDER_VOUCHES".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches" : "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        }
        return tmp;
    }

    private boolean isHolderOfKeySubjectConfirmationMethod(String confirmationMethod) {
        return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(confirmationMethod);
    }

    private String getAuthStatementMethod(String tmpParam, boolean saml2) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified" : "urn:oasis:names:tc:SAML:1.0:am:unspecified";
        } else if ("PASSWORD".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:Password" : "urn:oasis:names:tc:SAML:1.0:am:password";
        } else if ("KERBEROS".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos" : "urn:ietf:rfc:1510";
        } else if ("TLS".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient" : "urn:ietf:rfc:2246";
        } else if ("X509".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:X509" : "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
        } else if ("PGP".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:PGP" : "urn:oasis:names:tc:SAML:1.0:am:PGP";
        } else if ("SRP".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:SecureRemotePassword" : "urn:ietf:rfc:2945";
        } else if ("SPKI".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:SPKI" : "urn:oasis:names:tc:SAML:1.0:am:SPKI";
        } else if ("DSIG".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig" : "urn:ietf:rfc:3075";
        } else if ("HARDWARE".equals(tmp)) {
            if (!saml2) {
                tmp = "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
            }
        } else if ("XKMS".equals(tmp)) {
            if (!saml2) {
                tmp = "urn:oasis:names:tc:SAML:1.0:am:XKMS";
            }
        } else if ("INTERNET_PROTOCOL".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol";
            }
        } else if ("INTERNET_PROTOCOL_PASSWORD".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword";
            }
        } else if ("MOBILE_ONE_FACTOR_UNREGISTERED".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorUnregistered";
            }
        } else if ("MOBILE_TWO_FACTOR_UNREGISTERED".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorUnregistered";
            }
        } else if ("MOBILE_ONE_FACTOR_CONTRACT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorContract";
            }
        } else if ("MOBILE_TWO_FACTOR_CONTRACT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract";
            }
        } else if ("PASSWORD_PROTECTED_TRANSPORT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
        } else if ("PREVIOUS_SESSION".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession";
            }
        } else if ("SMARTCARD".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard";
            }
        } else if ("SMARTCARD_PKI".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI";
            }
        } else if ("SOFTWARE_PKI".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI";
            }
        } else if ("TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:Telephony";
            }
        } else if ("NOMAD_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:NomadTelephony";
            }
        } else if ("PERSONAL_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PersonalTelephony";
            }
        } else if ("AUTHENTICATED_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:AuthenticatedTelephony";
            }
        } else if ("TIME_SYNC".equals(tmp) && saml2) {
            tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:TimeSyncToken";
        }
        return tmp;
    }

    private String getAttributeFormat(String tmpParam) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        } else if ("URI".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
        } else if ("BASIC".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
        }
        return tmp;
    }

    public boolean isUseKeystoreCache() {
        return this.useKeystoreCache;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getIssuerValue() {
        return this.issuerValue;
    }

    public String getIssuerQualifier() {
        return this.issuerQualifier;
    }

    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    public boolean isSignAssertion() {
        return this.signAssertion;
    }

    public Crypto getSignAssertionCrypto() throws Exception {
        if (this.signAssertionCrypto == null) {
            this.initSignAssertionCrypto();
        }
        return this.signAssertionCrypto;
    }

    private synchronized void initSignAssertionCrypto() throws Exception {
        if (this.signAssertionCrypto == null) {
            if (this.signAssertionCryptoPropFile != null) {
                this.signAssertionCrypto = CryptoFactory.getInstance((String)this.signAssertionCryptoPropFile);
            } else if (this.signAssertionCryptoPropCustomKeystoreFile != null) {
                Properties pMerlin = SAMLUtilities.convertToMerlinProperties(this.signAssertionCryptoPropCustomKeystoreType, this.signAssertionCryptoPropCustomKeystoreFile, this.signAssertionCryptoPropCustomKeystorePassword, this.useKeystoreCache, this.signAssertionCryptoPropCustomKeystoreBYOKPolicy);
                if (this.requestInfo != null) {
                    pMerlin.put("requestInfo", this.requestInfo);
                }
                this.signAssertionCrypto = CryptoFactory.getInstance((Properties)pMerlin);
            } else {
                this.signAssertionCrypto = CryptoFactory.getInstance((Properties)this.p);
            }
        }
    }

    public String getSignAssertionIssuerKeyPassword() {
        return this.signAssertionIssuerKeyPassword;
    }

    public String getSignAssertionIssuerKeyName() {
        return this.signAssertionIssuerKeyName;
    }

    public boolean isSignAssertionSendKeyValue() {
        return this.signAssertionSendKeyValue;
    }

    public String getSignAssertionSignatureAlgorithm() {
        return this.signAssertionSignatureAlgorithm;
    }

    public String getSignAssertionSignatureDigestAlgorithm() {
        return this.signAssertionSignatureDigestAlgorithm;
    }

    public String getSignAssertionCanonicalizationAlgorithm() {
        return this.signAssertionCanonicalizationAlgorithm;
    }

    public boolean isSubjectEnabled() {
        return this.subjectEnabled;
    }

    public String getSubjectNameIDValue() {
        return this.subjectNameIDValue;
    }

    public String getSubjectNameIDQualifier() {
        return this.subjectNameIDQualifier;
    }

    public String getSubjectNameIDFormat() {
        return this.subjectNameIDFormat;
    }

    public String getSubjectConfirmationMethod() {
        return this.subjectConfirmationMethod;
    }

    public int getSubjectConfirmationDataNotBefore() {
        return this.subjectConfirmationDataNotBefore;
    }

    public int getSubjectConfirmationDataNotOnOrAfter() {
        return this.subjectConfirmationDataNotOnOrAfter;
    }

    public String getSubjectConfirmationDataAddress() {
        return this.subjectConfirmationDataAddress;
    }

    public String getSubjectConfirmationDataInResponseTo() {
        return this.subjectConfirmationDataInResponseTo;
    }

    public String getSubjectConfirmationDataRecipient() {
        return this.subjectConfirmationDataRecipient;
    }

    public Crypto getSubjectConfirmationMethodHolderOfKeyCrypto() throws Exception {
        if (this.subjectConfirmationMethodHolderOfKeyCrypto == null) {
            this.initSubjectConfirmationMethodHolderOfKeyCrypto();
        }
        return this.subjectConfirmationMethodHolderOfKeyCrypto;
    }

    private synchronized void initSubjectConfirmationMethodHolderOfKeyCrypto() throws Exception {
        if (this.subjectConfirmationMethodHolderOfKeyCrypto == null) {
            if (this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesFile != null) {
                this.subjectConfirmationMethodHolderOfKeyCrypto = CryptoFactory.getInstance((String)this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesFile);
            } else if (this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile != null) {
                Properties pMerlin = SAMLUtilities.convertToMerlinProperties(this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreType, this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreFile, this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystorePassword, this.useKeystoreCache, this.subjectConfirmationMethodHolderOfKeyCryptoPropertiesCustomKeystoreBYOKPolicy);
                if (this.requestInfo != null) {
                    pMerlin.put("requestInfo", this.requestInfo);
                }
                this.subjectConfirmationMethodHolderOfKeyCrypto = CryptoFactory.getInstance((Properties)pMerlin);
            } else {
                this.subjectConfirmationMethodHolderOfKeyCrypto = CryptoFactory.getInstance((Properties)this.p);
            }
        }
    }

    public String getSubjectConfirmationMethodHolderOfKeyCryptoCertificateAlias() {
        return this.subjectConfirmationMethodHolderOfKeyCryptoCertificateAlias;
    }

    public boolean isConditionsEnabled() {
        return this.conditionsEnabled;
    }

    public int getConditionsDataNotBefore() {
        return this.conditionsDataNotBefore;
    }

    public int getConditionsDataNotOnOrAfter() {
        return this.conditionsDataNotOnOrAfter;
    }

    public String getConditionsAudienceURI() {
        return this.conditionsAudienceURI;
    }

    public boolean isAuthnStatementEnabled() {
        return this.authnStatementEnabled;
    }

    public int getAuthnStatementDataInstant() {
        return this.authnStatementDataInstant;
    }

    public Date getAuthnStatementDataInstantDate() {
        return this.authnStatementDataInstantDate;
    }

    public int getAuthnStatementDataNotOnOrAfter() {
        return this.authnStatementDataNotOnOrAfter;
    }

    public Date getAuthnStatementDataNotOnOrAfterDate() {
        return this.authnStatementDataNotOnOrAfterDate;
    }

    public String getAuthnStatementClassRef() {
        return this.authnStatementClassRef;
    }

    public String getAuthnStatementDeclRef() {
        return this.authnStatementDeclRef;
    }

    public String getAuthnSubjectLocalityIpAddress() {
        return this.authnSubjectLocalityIpAddress;
    }

    public String getAuthnSubjectLocalityDnsAddress() {
        return this.authnSubjectLocalityDnsAddress;
    }

    public List<SAMLBuilderConfigAttribute> getAttributes() {
        return this.attributes;
    }
}

