/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.saml;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.utils.certificate.KeystoreType;

public class SAMLUtilities {
    private SAMLUtilities() {
    }

    public static Instant minutesOperator(Instant dateTime, Integer intValue) {
        if (intValue != null) {
            Instant dateTimeRes = null;
            dateTimeRes = intValue == 0 ? dateTime : (intValue > 0 ? dateTime.plus((long)intValue.intValue(), ChronoUnit.MINUTES) : dateTime.minus(intValue * -1, ChronoUnit.MINUTES));
            return dateTimeRes;
        }
        return dateTime;
    }

    public static void injectSignaturePropRefIdIntoSamlConfig(Map<String, Object> wssProperties) throws SecurityException {
        if (wssProperties != null && wssProperties.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(wssProperties.keySet());
            for (String key : keys) {
                Object oValue = wssProperties.get(key);
                String value = null;
                if (oValue instanceof String) {
                    value = (String)oValue;
                }
                if ("signatureParts".equals(key)) {
                    Properties samlConfig;
                    Object o;
                    if (value == null || !value.contains("SAML_TEMPLATE_NS")) continue;
                    String samlVersion = null;
                    if (wssProperties.containsKey("samlPropRefId") && (o = wssProperties.get("samlPropRefId")) instanceof Properties && (samlConfig = (Properties)o).containsKey("openspcoop2.saml.version")) {
                        samlVersion = samlConfig.getProperty("openspcoop2.saml.version");
                    }
                    if (samlVersion == null) {
                        throw new SecurityException("SAML version undefined");
                    }
                    if ("2.0".equals(samlVersion)) {
                        while (value.contains("SAML_TEMPLATE_NS")) {
                            value = value.replace("SAML_TEMPLATE_NS", "urn:oasis:names:tc:SAML:2.0:assertion");
                        }
                    } else {
                        while (value.contains("SAML_TEMPLATE_NS")) {
                            value = value.replace("SAML_TEMPLATE_NS", "urn:oasis:names:tc:SAML:1.0:assertion");
                        }
                    }
                    wssProperties.remove(key);
                    wssProperties.put(key, value);
                    continue;
                }
                if (!"signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key) && !"signaturePropRefId_convertParamsIntoSamlPropRefId_holderOfKey".equals(key) || value == null || !wssProperties.containsKey(value)) continue;
                SAMLUtilities.injectSignaturePropRefIdIntoSamlConfig(wssProperties, key, value);
            }
        }
    }

    private static void injectSignaturePropRefIdIntoSamlConfig(Map<String, Object> wssProperties, String key, String value) throws SecurityException {
        Object o;
        Object o2;
        Properties signaturePropRefiId = null;
        String signatureAlias = null;
        String signaturePassword = null;
        if (wssProperties.containsKey("signaturePropRefId") && (o2 = wssProperties.get("signaturePropRefId")) instanceof Properties) {
            signaturePropRefiId = (Properties)o2;
        }
        if (wssProperties.containsKey("signatureUser")) {
            o2 = wssProperties.get("signatureUser");
            if (o2 instanceof String) {
                signatureAlias = (String)o2;
            }
        } else if (wssProperties.containsKey("user") && (o2 = wssProperties.get("user")) instanceof String) {
            signatureAlias = (String)o2;
        }
        if (wssProperties.containsKey("signaturePassword") && (o2 = wssProperties.get("signaturePassword")) instanceof String) {
            signaturePassword = (String)o2;
        }
        String signatureAlgorithm = null;
        String signatureDigestAlgorithm = null;
        String signatureC14nAlgorithmExclusive = null;
        if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
            if (wssProperties.containsKey("signatureAlgorithm") && (o = wssProperties.get("signatureAlgorithm")) instanceof String) {
                signatureAlgorithm = (String)o;
            }
            if (wssProperties.containsKey("signatureDigestAlgorithm") && (o = wssProperties.get("signatureDigestAlgorithm")) instanceof String) {
                signatureDigestAlgorithm = (String)o;
            }
            if (wssProperties.containsKey("signatureC14nAlgorithm") && (o = wssProperties.get("signatureC14nAlgorithm")) instanceof String) {
                signatureC14nAlgorithmExclusive = (String)o;
            }
        }
        if ((o = wssProperties.get(value)) instanceof Properties) {
            String password;
            String file;
            Properties samlConfig = (Properties)o;
            String type = signaturePropRefiId.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            if (type != null) {
                if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.cryptoProp.keystore.type", type);
                } else {
                    samlConfig.put("openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.type", type);
                }
            }
            if ((file = signaturePropRefiId.getProperty("org.apache.ws.security.crypto.merlin.file")) == null) {
                throw new SecurityException("Keystore file in signaturePropRefId undefined");
            }
            if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                samlConfig.put("openspcoop2.saml.assertion.sign.cryptoProp.keystore.file", file);
            } else {
                samlConfig.put("openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file", file);
            }
            String byokPolicy = signaturePropRefiId.getProperty("org.apache.ws.security.crypto.merlin.file.byok");
            if (byokPolicy != null) {
                if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.cryptoProp.keystore.file.byok", byokPolicy);
                } else {
                    samlConfig.put("openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.file.byok", byokPolicy);
                }
            }
            if ((password = signaturePropRefiId.getProperty("org.apache.ws.security.crypto.merlin.keystore.password")) == null && MessageSecurityContext.isPasswordRequired(signaturePropRefiId, false)) {
                throw new SecurityException("Keystore password in signaturePropRefId undefined");
            }
            if (password != null) {
                if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.cryptoProp.keystore.password", password);
                } else {
                    samlConfig.put("openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties.keystore.password", password);
                }
            }
            if (signatureAlias == null) {
                throw new SecurityException("Signature alias undefined");
            }
            if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                samlConfig.put("openspcoop2.saml.assertion.sign.key.name", signatureAlias);
            } else {
                samlConfig.put("openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoCertificateAlias", signatureAlias);
            }
            if ("signaturePropRefId_convertParamsIntoSamlPropRefId".equals(key)) {
                if (signaturePassword == null && MessageSecurityContext.isPasswordRequired(signaturePropRefiId, true)) {
                    throw new SecurityException("Signature password undefined");
                }
                if (signaturePassword != null) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.key.password", signaturePassword);
                }
                if (signatureAlgorithm != null) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.signatureAlgorithm", signatureAlgorithm);
                }
                if (signatureDigestAlgorithm != null) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.signatureDigestAlgorithm", signatureDigestAlgorithm);
                }
                if (signatureC14nAlgorithmExclusive != null) {
                    samlConfig.put("openspcoop2.saml.assertion.sign.canonicalizationAlgorithm", signatureC14nAlgorithmExclusive);
                }
            }
        }
    }

    public static Properties convertToMerlinProperties(String keystoreType, String keystoreFile, String keystorePassword, boolean useKeystoreCache, String byokPolicy) throws SecurityException {
        Properties p = new Properties();
        if (useKeystoreCache) {
            p.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
        } else {
            p.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        }
        if (keystoreType != null) {
            p.put("org.apache.ws.security.crypto.merlin.keystore.type", keystoreType);
        }
        if (keystoreFile == null) {
            throw new SecurityException("Keystore file undefined");
        }
        p.put("org.apache.ws.security.crypto.merlin.file", keystoreFile);
        if (keystorePassword == null) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new SecurityException("Keystore password undefined");
            }
        }
        if (keystorePassword != null) {
            p.put("org.apache.ws.security.crypto.merlin.keystore.password", keystorePassword);
        }
        if (byokPolicy != null) {
            p.put("org.apache.ws.security.crypto.merlin.file.byok", byokPolicy);
        }
        return p;
    }
}

