/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.wss4j;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.security.message.wss4j.TrustStoreSecurityProvider;

public class SAMLReceiverProvider
extends TrustStoreSecurityProvider {
    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        super.validate(mapProperties);
        Properties p = mapProperties.get("signaturePropRefId");
        if (p != null && p.size() > 0) {
            String file = p.getProperty("org.apache.ws.security.crypto.merlin.file");
            if (file != null && StringUtils.isNotEmpty((CharSequence)file)) {
                InputValidationUtils.validateTextAreaInput((String)file, (String)"Signature - TrustStore - Path");
            }
            if ((file = p.getProperty("org.apache.ws.security.crypto.merlin.x509crl.file")) != null && StringUtils.isNotEmpty((CharSequence)file)) {
                InputValidationUtils.validateTextAreaInput((String)file, (String)"Signature - TrustStore - CRL File(s)");
            }
        }
    }
}

