/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.wss4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.security.message.constants.EncryptionKeyTransportAlgorithm;
import org.openspcoop2.security.message.xml.SecurityProvider;

public class WSS4JSecurityProvider
extends SecurityProvider {
    private static final String PASSWORD = "Password";
    private static final String PASSWORD_PREFIX = "Password ";

    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        Properties defaultProperties = MultiPropertiesUtilities.getDefaultProperties(mapProperties);
        Properties samlConfig = mapProperties.get("samlPropRefId");
        boolean envelopedSaml = false;
        if (defaultProperties.containsKey("signatureActionChoice")) {
            String tmp = defaultProperties.getProperty("signatureActionChoice");
            envelopedSaml = Boolean.parseBoolean(tmp);
        }
        boolean holderOfKey = false;
        if (defaultProperties.containsKey("validateSamlSubjectConfirmationType")) {
            tmp = defaultProperties.getProperty("validateSamlSubjectConfirmationType");
            holderOfKey = "holder-of-key".equals(tmp);
        } else if (samlConfig != null && samlConfig.containsKey("openspcoop2.saml.subject.confirmation.method")) {
            tmp = samlConfig.getProperty("openspcoop2.saml.subject.confirmation.method");
            holderOfKey = "HOLDER_OF_KEY".equals(tmp);
        }
        if (holderOfKey && !envelopedSaml) {
            throw new ProviderValidationException("Subject Confirmation Method 'Holder of Key' require Enveloped SAML Signature");
        }
        boolean bearer = false;
        if (samlConfig != null && samlConfig.containsKey("openspcoop2.saml.subject.confirmation.method")) {
            String tmp = samlConfig.getProperty("openspcoop2.saml.subject.confirmation.method");
            bearer = "BEARER".equals(tmp);
        }
        if (bearer && !envelopedSaml) {
            throw new ProviderValidationException("Subject Confirmation Method 'Bearer' require Enveloped SAML Signature");
        }
        super.validate(mapProperties);
    }

    @Override
    public List<String> getValues(String id) throws ProviderException {
        if ("passwordType".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("PasswordDigest");
            l.add("PasswordText");
            l.add("PasswordNone");
            return l;
        }
        if ("usernameTokenPasswordMode".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("single");
            l.add("map");
            return l;
        }
        if ("issuerFormat2".equals(id) || "subjectFormat1".equals(id) || "subjectFormat2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("UNSPECIFIED");
            l.add("EMAIL");
            l.add("X509_SUBJECT");
            l.add("WIN_DOMAIN_QUALIFIED");
            if ("issuerFormat2".equals(id) || "subjectFormat2".equals(id)) {
                l.add("KERBEROS");
                l.add("ENTITY");
                l.add("PERSISTENT");
                l.add("TRANSIENT");
                l.add("ENCRYPTED");
            }
            return l;
        }
        if ("subjectConfirmationMethod1".equals(id) || "subjectConfirmationMethod2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            if ("subjectConfirmationMethod1".equals(id)) {
                l.add("ARTIFACT");
                l.add("IDENTITY");
            }
            l.add("BEARER");
            l.add("HOLDER_OF_KEY");
            l.add("SENDER_VOUCHES");
            return l;
        }
        if ("authnContextClassRef1".equals(id) || "authnContextClassRef2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("UNSPECIFIED");
            l.add("PASSWORD");
            l.add("KERBEROS");
            l.add("TLS");
            l.add("X509");
            l.add("PGP");
            l.add("SRP");
            l.add("SPKI");
            l.add("DSIG");
            if ("authnContextClassRef1".equals(id)) {
                l.add("HARDWARE");
                l.add("XKMS");
            }
            if ("authnContextClassRef2".equals(id)) {
                l.add("INTERNET_PROTOCOL");
                l.add("INTERNET_PROTOCOL_PASSWORD");
                l.add("MOBILE_ONE_FACTOR_UNREGISTERED");
                l.add("MOBILE_TWO_FACTOR_UNREGISTERED");
                l.add("MOBILE_ONE_FACTOR_CONTRACT");
                l.add("MOBILE_TWO_FACTOR_CONTRACT");
                l.add("PASSWORD_PROTECTED_TRANSPORT");
                l.add("PREVIOUS_SESSION");
                l.add("SMARTCARD");
                l.add("SMARTCARD_PKI");
                l.add("SOFTWARE_PKI");
                l.add("TELEPHONY");
                l.add("NOMAD_TELEPHONY");
                l.add("PERSONAL_TELEPHONY");
                l.add("AUTHENTICATED_TELEPHONY");
                l.add("TIME_SYNC");
            }
            return l;
        }
        if (id.startsWith("attributeStatementFormat_")) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("UNSPECIFIED");
            l.add("URI");
            l.add("BASIC");
            return l;
        }
        return super.getValues(id);
    }

    @Override
    public List<String> getLabels(String id) throws ProviderException {
        if ("passwordType".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(PASSWORD_PREFIX + "PasswordDigest".replace(PASSWORD, ""));
            l.add(PASSWORD_PREFIX + "PasswordText".replace(PASSWORD, ""));
            l.add(PASSWORD_PREFIX + "PasswordNone".replace(PASSWORD, ""));
            return l;
        }
        if ("usernameTokenPasswordMode".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("Default");
            l.add("Mappa");
            return l;
        }
        if ("issuerFormat2".equals(id) || "subjectFormat1".equals(id) || "subjectFormat2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            l.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            l.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
            l.add("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
            if ("issuerFormat2".equals(id) || "subjectFormat2".equals(id)) {
                l.add("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
                l.add("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
                l.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
                l.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                l.add("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted");
            }
            return l;
        }
        if ("subjectConfirmationMethod1".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:1.0:cm:artifact");
            l.add("urn:com:sun:identity");
            l.add("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            l.add("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
            l.add("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
            return l;
        }
        if ("subjectConfirmationMethod2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            l.add("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
            l.add("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
            return l;
        }
        if ("authnContextClassRef1".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:1.0:am:unspecified");
            l.add("urn:oasis:names:tc:SAML:1.0:am:password");
            l.add("urn:ietf:rfc:1510");
            l.add("urn:ietf:rfc:2246");
            l.add("urn:oasis:names:tc:SAML:1.0:am:X509-PKI");
            l.add("urn:oasis:names:tc:SAML:1.0:am:PGP");
            l.add("urn:ietf:rfc:2945");
            l.add("urn:oasis:names:tc:SAML:1.0:am:SPKI");
            l.add("urn:ietf:rfc:3075");
            l.add("urn:oasis:names:tc:SAML:1.0:am:HardwareToken");
            l.add("urn:oasis:names:tc:SAML:1.0:am:XKMS");
            return l;
        }
        if ("authnContextClassRef2".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PGP");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:SecureRemotePassword");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:SPKI");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorUnregistered");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorUnregistered");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorContract");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Telephony");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:NomadTelephony");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PersonalTelephony");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:AuthenticatedTelephony");
            l.add("urn:oasis:names:tc:SAML:2.0:ac:classes:TimeSyncToken");
            return l;
        }
        if (id.startsWith("attributeStatementFormat_")) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            l.add("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            l.add("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
            return l;
        }
        return super.getLabels(id);
    }

    @Override
    public String getDefault(String id) throws ProviderException {
        if ("usernameTokenPasswordMode".equals(id)) {
            return "single";
        }
        if ("encryptionKeyTransportAlgorithm".equals(id)) {
            return EncryptionKeyTransportAlgorithm.RSA_OAEP.getUri();
        }
        if ("issuerFormat2".equals(id) || "subjectFormat1".equals(id) || "subjectFormat2".equals(id)) {
            return "UNSPECIFIED";
        }
        if ("subjectConfirmationMethod1".equals(id) || "subjectConfirmationMethod2".equals(id)) {
            return "SENDER_VOUCHES";
        }
        if ("authnContextClassRef1".equals(id) || "authnContextClassRef2".equals(id)) {
            return "UNSPECIFIED";
        }
        if (id.startsWith("attributeStatementFormat_")) {
            return "UNSPECIFIED";
        }
        return super.getDefault(id);
    }
}

