/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.allarmi.status;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.monitor.engine.status.BaseStatus;
import org.openspcoop2.monitor.engine.status.IStatus;
import org.openspcoop2.web.monitor.allarmi.bean.AllarmiSearchForm;
import org.openspcoop2.web.monitor.allarmi.dao.AllarmiService;
import org.openspcoop2.web.monitor.allarmi.dao.IAllarmiService;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.status.BaseSondaPdd;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AllarmeStatus
extends BaseSondaPdd
implements ISondaPdd {
    private transient AllarmiSearchForm searchForm = new AllarmiSearchForm();
    private transient IAllarmiService allarmiService = new AllarmiService();
    private static final long serialVersionUID = 1L;
    private static final String PATH_ALLARMI = "/allarmi/pages/list/statoAllarmi.jsf";
    private int totOk = 0;
    private int totAllWarn = 0;
    private int totAllErr = 0;
    private int totWarnAkc = 0;
    private int totErrAck = 0;
    private int totWarnNoAck = 0;
    private int totErrNoAck = 0;
    private int totaleAllarmi = 0;
    private String requestContextPath;
    private transient AllarmiSearchForm searchFormPaginaStatoAllarmi;
    private boolean allarmiAssociazioneAcknowledgedStatoAllarme;

    public AllarmeStatus(String nome, Logger log, Properties prop) throws Exception {
        super(nome, log, prop);
        ((AllarmiService)this.allarmiService).setSearch(this.searchForm);
    }

    protected void init() throws Exception {
        try {
            this.log.debug("Init Sonda AllarmeStatus in corso...");
            this.listaStatus = new ArrayList();
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)this.log);
            AlarmEngineConfig alarmEngineConfig = AlarmConfigProperties.getAlarmConfiguration((Logger)this.log, (String)pddMonitorProperties.getAllarmiConfigurazione(), (String)pddMonitorProperties.getConfDirectory());
            this.allarmiAssociazioneAcknowledgedStatoAllarme = alarmEngineConfig.isOptionsAcknowledgedStatusAssociation();
            BaseStatus statoAllarmi = new BaseStatus();
            statoAllarmi.setNome("Dettagli");
            this.listaStatus.add(statoAllarmi);
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            ExternalContext externalContext = currentInstance.getExternalContext();
            this.requestContextPath = externalContext.getRequestContextPath();
            ServletContext servletContext = (ServletContext)externalContext.getContext();
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            if (context == null) {
                throw new Exception("Context is null");
            }
            this.searchFormPaginaStatoAllarmi = (AllarmiSearchForm)((Object)context.getBean("searchFormAllarmi"));
            this.log.debug("Init Sonda AllarmeStatus completato.");
        }
        catch (Exception e) {
            this.log.error("Si e' verificato un errore durante l'Init AllarmeStatus Status: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public List<IStatus> updateStato() throws Exception {
        for (IStatus status : this.listaStatus) {
            try {
                this.totOk = this.allarmiService.getCountAllarmiByStato("Ok", null).intValue();
                if (this.allarmiAssociazioneAcknowledgedStatoAllarme) {
                    this.totWarnAkc = this.allarmiService.getCountAllarmiByStato("Warn", 1).intValue();
                    this.totWarnNoAck = this.allarmiService.getCountAllarmiByStato("Warn", 0).intValue();
                    this.totErrAck = this.allarmiService.getCountAllarmiByStato("Error", 1).intValue();
                    this.totErrNoAck = this.allarmiService.getCountAllarmiByStato("Error", 0).intValue();
                    this.totaleAllarmi = this.totOk + this.totWarnAkc + this.totWarnNoAck + this.totErrAck + this.totErrNoAck;
                } else {
                    this.totAllWarn = this.allarmiService.getCountAllarmiByStato("Warn", null).intValue();
                    this.totAllErr = this.allarmiService.getCountAllarmiByStato("Error", null).intValue();
                    this.totaleAllarmi = this.totOk + this.totAllWarn + this.totAllErr;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Allarmi attivi con stato Ok: ").append(this.totOk);
                if (this.allarmiAssociazioneAcknowledgedStatoAllarme) {
                    sb.append(", Warning: ").append(this.totWarnNoAck);
                    sb.append(", Warning (Ack): ").append(this.totWarnAkc);
                    sb.append(", Error: ").append(this.totErrNoAck);
                    sb.append(", Error (Ack): ").append(this.totErrAck);
                } else {
                    sb.append(", Warning: ").append(this.totAllWarn);
                    sb.append(", Error: ").append(this.totAllErr);
                }
                sb.append(".");
                status.setStato(this.getStatoSondaPdd());
                status.setDescrizione(sb.toString());
            }
            catch (Exception e) {
                this.log.error("Si e' verificato un errore durante l'updateStato: " + e.getMessage(), (Throwable)e);
                status.setStato(SondaStatus.ERROR);
                status.setDescrizione(e.getMessage());
            }
        }
        return this.listaStatus;
    }

    public String getMessaggioStatoSondaPdd() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.totaleAllarmi != -1) {
            if (this.totaleAllarmi == this.totOk) {
                sb.append("Non risultano anomalie");
            } else if (this.allarmiAssociazioneAcknowledgedStatoAllarme) {
                if (this.totErrNoAck > 0) {
                    sb.append("Il sistema ha rilevato condizioni di errore");
                } else if (this.totWarnNoAck > 0) {
                    sb.append("Il sistema ha rilevato condizioni di warning");
                } else {
                    sb.append("Risultano anomalie in fase di gestione");
                }
            } else if (this.totAllErr <= 0) {
                sb.append("Il sistema ha rilevato condizioni di warning");
            } else {
                sb.append("Il sistema ha rilevato condizioni di errore");
            }
        } else {
            sb.append("La sonda non \u00e8 funzionante");
        }
        return sb.toString();
    }

    public String getLinkDettaglio() throws Exception {
        String path = null;
        path = this.totaleAllarmi != -1 ? (this.totaleAllarmi == this.totOk ? null : this.requestContextPath + PATH_ALLARMI) : null;
        if (path != null && this.searchFormPaginaStatoAllarmi != null) {
            this.searchFormPaginaStatoAllarmi.ripulisci();
        }
        return path;
    }

    public SondaStatus getStatoSondaPdd() throws Exception {
        if (this.totaleAllarmi == -1 || this.totOk == -1) {
            return SondaStatus.ERROR;
        }
        if (this.allarmiAssociazioneAcknowledgedStatoAllarme ? this.totErrAck == -1 || this.totErrNoAck == -1 || this.totWarnAkc == -1 || this.totWarnNoAck == -1 : this.totAllErr == -1 || this.totAllWarn == -1) {
            return SondaStatus.ERROR;
        }
        if (this.allarmiAssociazioneAcknowledgedStatoAllarme) {
            if (this.totErrNoAck > 0) {
                return SondaStatus.ERROR;
            }
            if (this.totWarnNoAck > 0) {
                return SondaStatus.WARNING;
            }
            return SondaStatus.OK;
        }
        if (this.totAllErr > 0) {
            return SondaStatus.ERROR;
        }
        if (this.totAllWarn > 0) {
            return SondaStatus.WARNING;
        }
        return SondaStatus.OK;
    }

    public void reset() throws Exception {
        super.reset();
        this.totOk = -1;
        this.totAllErr = -1;
        this.totAllWarn = -1;
        this.totaleAllarmi = -1;
        this.totErrAck = -1;
        this.totErrNoAck = -1;
        this.totWarnAkc = -1;
        this.totWarnNoAck = -1;
    }
}

