/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogBase;
import org.apache.commons.chain.web.ChainResources;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainListener
implements ServletContextListener {
    public static final String CONFIG_ATTR = "org.apache.commons.chain.CONFIG_ATTR";
    public static final String CONFIG_CLASS_RESOURCE = "org.apache.commons.chain.CONFIG_CLASS_RESOURCE";
    public static final String CONFIG_WEB_RESOURCE = "org.apache.commons.chain.CONFIG_WEB_RESOURCE";
    public static final String RULE_SET = "org.apache.commons.chain.RULE_SET";

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String attr = context.getInitParameter(CONFIG_ATTR);
        if (attr != null) {
            context.removeAttribute(attr);
        }
        CatalogFactory.clear();
    }

    public void contextInitialized(ServletContextEvent event) {
        Log log = LogFactory.getLog(ChainListener.class);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing chain listener");
        }
        ServletContext context = event.getServletContext();
        String attr = context.getInitParameter(CONFIG_ATTR);
        String classResources = context.getInitParameter(CONFIG_CLASS_RESOURCE);
        String ruleSet = context.getInitParameter(RULE_SET);
        String webResources = context.getInitParameter(CONFIG_WEB_RESOURCE);
        Catalog catalog = null;
        if (attr != null && (catalog = (Catalog)context.getAttribute(attr)) == null) {
            catalog = new CatalogBase();
        }
        ConfigParser parser = new ConfigParser();
        if (ruleSet != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                Class<?> clazz = loader.loadClass(ruleSet);
                parser.setRuleSet((RuleSet)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception initalizing RuleSet '" + ruleSet + "' instance: " + e.getMessage());
            }
        }
        if (attr == null) {
            this.parseJarResources(context, parser, log);
            ChainResources.parseClassResources(classResources, parser);
            ChainResources.parseWebResources(context, webResources, parser);
        } else {
            this.parseJarResources(catalog, context, parser, log);
            ChainResources.parseClassResources(catalog, classResources, parser);
            ChainResources.parseWebResources(catalog, context, webResources, parser);
        }
        if (attr != null) {
            context.setAttribute(attr, (Object)catalog);
        }
    }

    private void parseJarResources(ServletContext context, ConfigParser parser, Log log) {
        HashSet jars = context.getResourcePaths("/WEB-INF/lib");
        if (jars == null) {
            jars = new HashSet();
        }
        String path2 = null;
        for (String path2 : jars) {
            if (!path2.endsWith(".jar")) continue;
            URL resourceURL = null;
            try {
                URL jarURL = context.getResource(path2);
                resourceURL = new URL("jar:" + this.translate(jarURL.toExternalForm()) + "!/META-INF/chain-config.xml");
                if (resourceURL == null) continue;
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (is == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not Found: " + resourceURL));
                    continue;
                }
                is.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing: " + resourceURL));
                }
                parser.parse(resourceURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception parsing chain config resource '" + resourceURL.toExternalForm() + "': " + e.getMessage());
            }
        }
    }

    private void parseJarResources(Catalog catalog, ServletContext context, ConfigParser parser, Log log) {
        HashSet jars = context.getResourcePaths("/WEB-INF/lib");
        if (jars == null) {
            jars = new HashSet();
        }
        String path2 = null;
        for (String path2 : jars) {
            if (!path2.endsWith(".jar")) continue;
            URL resourceURL = null;
            try {
                URL jarURL = context.getResource(path2);
                resourceURL = new URL("jar:" + this.translate(jarURL.toExternalForm()) + "!/META-INF/chain-config.xml");
                if (resourceURL == null) continue;
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (is == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not Found: " + resourceURL));
                    continue;
                }
                is.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing: " + resourceURL));
                }
                parser.parse(catalog, resourceURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception parsing chain config resource '" + resourceURL.toExternalForm() + "': " + e.getMessage());
            }
        }
    }

    private String translate(String value) {
        int index;
        while ((index = value.indexOf(32)) >= 0) {
            value = value.substring(0, index) + "%20" + value.substring(index + 1);
        }
        return value;
    }
}

