/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.chain;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.action.ActionServlet;
import org.govway.struts.action.RequestProcessor;
import org.govway.struts.chain.contexts.ActionContext;
import org.govway.struts.chain.contexts.ServletActionContext;
import org.govway.struts.config.ControllerConfig;
import org.govway.struts.config.ModuleConfig;
import org.govway.struts.upload.MultipartRequestWrapper;
import org.govway.struts.util.RequestUtils;

public class ComposableRequestProcessor
extends RequestProcessor {
    private static final Class[] SERVLET_ACTION_CONTEXT_CTOR_SIGNATURE = new Class[]{ServletContext.class, HttpServletRequest.class, HttpServletResponse.class};
    public static final String ACTION_CONTEXT_CLASS = "ACTION_CONTEXT_CLASS";
    protected static final Log LOG = LogFactory.getLog(ComposableRequestProcessor.class);
    protected CatalogFactory catalogFactory = null;
    protected Catalog catalog = null;
    protected Command command = null;
    private Class actionContextClass;
    private Constructor servletActionContextConstructor = null;

    @Override
    public void destroy() {
        super.destroy();
        this.catalogFactory = null;
        this.catalog = null;
        this.command = null;
        this.actionContextClass = null;
        this.servletActionContextConstructor = null;
    }

    @Override
    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        LOG.info((Object)("Initializing composable request processor for module prefix '" + moduleConfig.getPrefix() + "'"));
        super.init(servlet, moduleConfig);
        this.initCatalogFactory(servlet, moduleConfig);
        ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
        String catalogName = controllerConfig.getCatalog();
        this.catalog = this.catalogFactory.getCatalog(catalogName);
        if (this.catalog == null) {
            throw new ServletException("Cannot find catalog '" + catalogName + "'");
        }
        String commandName = controllerConfig.getCommand();
        this.command = this.catalog.getCommand(commandName);
        if (this.command == null) {
            throw new ServletException("Cannot find command '" + commandName + "'");
        }
        this.setActionContextClassName(controllerConfig.getProperty(ACTION_CONTEXT_CLASS));
    }

    private void setActionContextClass(Class actionContextClass) {
        this.actionContextClass = actionContextClass;
        this.servletActionContextConstructor = actionContextClass != null ? ConstructorUtils.getAccessibleConstructor((Class)actionContextClass, (Class[])SERVLET_ACTION_CONTEXT_CTOR_SIGNATURE) : null;
    }

    private void setActionContextClassName(String className) throws ServletException {
        if (className != null && className.trim().length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setActionContextClassName: requested context class: " + className));
            }
            try {
                Class actionContextClass = RequestUtils.applicationClass(className);
                if (!ActionContext.class.isAssignableFrom(actionContextClass)) {
                    throw new UnavailableException("ActionContextClass [" + className + "] must implement ActionContext interface.");
                }
                this.setActionContextClass(actionContextClass);
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableException("ActionContextClass " + className + " not found.");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"setActionContextClassName: no className specified");
            }
            this.setActionContextClass(null);
        }
    }

    protected void initCatalogFactory(ActionServlet servlet, ModuleConfig moduleConfig) {
        if (this.catalogFactory != null) {
            return;
        }
        this.catalogFactory = CatalogFactory.getInstance();
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request = this.processMultipart(request);
        ActionContext context = this.contextInstance(request, response);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using processing chain for this request");
            }
            this.command.execute(context);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        context.release();
    }

    protected ActionContext contextInstance(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionContext context = this.createActionContextInstance(this.getServletContext(), request, response);
        this.initializeActionContext(context);
        return context;
    }

    protected ActionContext createActionContextInstance(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.actionContextClass == null) {
            return new ServletActionContext(servletContext, request, response);
        }
        try {
            if (this.servletActionContextConstructor == null) {
                return (ActionContext)this.actionContextClass.newInstance();
            }
            return (ActionContext)this.servletActionContextConstructor.newInstance(servletContext, request, response);
        }
        catch (Exception e) {
            throw new ServletException("Error creating ActionContext instance of type " + String.valueOf(this.actionContextClass), (Throwable)e);
        }
    }

    protected void initializeActionContext(ActionContext context) {
        if (context instanceof ServletActionContext) {
            ((ServletActionContext)context).setActionServlet(this.servlet);
        }
        context.setModuleConfig(this.moduleConfig);
    }

    @Override
    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return request;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return new MultipartRequestWrapper(request);
        }
        return request;
    }

    public void setCatalogFactory(CatalogFactory catalogFactory) {
        this.catalogFactory = catalogFactory;
    }
}

