/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.config;

import java.lang.reflect.InvocationTargetException;
import org.govway.struts.config.ActionConfig;
import org.govway.struts.config.BaseConfig;
import org.govway.struts.config.ModuleConfig;

public class ForwardConfig
extends BaseConfig {
    protected String inherit = null;
    protected boolean extensionProcessed = false;
    protected String name = null;
    protected String path = null;
    protected String module = null;
    protected boolean redirect = false;
    protected String command = null;
    protected String catalog = null;

    public ForwardConfig() {
    }

    public ForwardConfig(String name, String path, boolean redirect) {
        this.setName(name);
        this.setPath(path);
        this.setRedirect(redirect);
    }

    public ForwardConfig(String name, String path, boolean redirect, String module) {
        this.setName(name);
        this.setPath(path);
        this.setRedirect(redirect);
        this.setModule(module);
    }

    public ForwardConfig(ForwardConfig copyMe) {
        this(copyMe.getName(), copyMe.getPath(), copyMe.getRedirect(), copyMe.getModule());
    }

    public String getExtends() {
        return this.inherit;
    }

    public void setExtends(String inherit) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.inherit = inherit;
    }

    public boolean isExtensionProcessed() {
        return this.extensionProcessed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.path = path;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.module = module;
    }

    public boolean getRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.redirect = redirect;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.command = command;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.catalog = catalog;
    }

    protected boolean checkCircularInheritance(ModuleConfig moduleConfig, ActionConfig actionConfig) {
        String ancestorName = this.getExtends();
        if (ancestorName == null) {
            return false;
        }
        ForwardConfig ancestor = null;
        if (actionConfig != null && (ancestor = actionConfig.findForwardConfig(ancestorName)) == this) {
            ancestor = null;
        }
        if (ancestor == null && (ancestor = moduleConfig.findForwardConfig(ancestorName)) != null) {
            actionConfig = null;
        }
        while (ancestor != null) {
            if (ancestor == this) {
                return true;
            }
            ancestorName = ancestor.getExtends();
            if (ancestor.getName().equals(ancestorName)) {
                if (actionConfig == null) {
                    return false;
                }
                actionConfig = null;
            }
            ancestor = null;
            if (actionConfig != null) {
                ancestor = actionConfig.findForwardConfig(ancestorName);
            }
            if (ancestor != null || (ancestor = moduleConfig.findForwardConfig(ancestorName)) == null) continue;
            actionConfig = null;
        }
        return false;
    }

    public void inheritFrom(ForwardConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        if (this.getCatalog() == null) {
            this.setCatalog(config.getCatalog());
        }
        if (this.getCommand() == null) {
            this.setCommand(config.getCommand());
        }
        if (this.getModule() == null) {
            this.setModule(config.getModule());
        }
        if (this.getName() == null) {
            this.setName(config.getName());
        }
        if (this.getPath() == null) {
            this.setPath(config.getPath());
        }
        if (!this.getRedirect()) {
            this.setRedirect(config.getRedirect());
        }
        this.inheritProperties(config);
    }

    public void processExtends(ModuleConfig moduleConfig, ActionConfig actionConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        String ancestorName = this.getExtends();
        if (!this.extensionProcessed && ancestorName != null) {
            ForwardConfig baseConfig = null;
            boolean checkActionConfig = this != moduleConfig.findForwardConfig(this.getName());
            checkActionConfig &= actionConfig != null;
            if (checkActionConfig &= !ancestorName.equals(this.getName())) {
                baseConfig = actionConfig.findForwardConfig(ancestorName);
            }
            if (baseConfig == null) {
                baseConfig = moduleConfig.findForwardConfig(ancestorName);
            }
            if (baseConfig == null) {
                throw new NullPointerException("Unable to find forward '" + ancestorName + "' to extend.");
            }
            if (this.checkCircularInheritance(moduleConfig, actionConfig)) {
                throw new IllegalArgumentException("Circular inheritance detected for forward " + this.getName());
            }
            if (!baseConfig.isExtensionProcessed()) {
                baseConfig.processExtends(moduleConfig, actionConfig);
            }
            this.inheritFrom(baseConfig);
        }
        this.extensionProcessed = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ForwardConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",path=");
        sb.append(this.path);
        sb.append(",redirect=");
        sb.append(this.redirect);
        sb.append(",module=");
        sb.append(this.module);
        sb.append(",extends=");
        sb.append(this.inherit);
        sb.append(",catalog=");
        sb.append(this.catalog);
        sb.append(",command=");
        sb.append(this.command);
        sb.append("]");
        return sb.toString();
    }
}

