

-- GovWay Monitoraggio

-- ALLARMI

CREATE SEQUENCE seq_allarmi AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE allarmi
(
	-- Informazioni generiche
	nome VARCHAR(275) NOT NULL,
	alias VARCHAR(255) NOT NULL,
	descrizione VARCHAR(255),
	tipo VARCHAR(255) NOT NULL,
	tipo_allarme VARCHAR(255) NOT NULL,
	-- Stato allarme (0=OK, 1=Warning, 2=Allarme)
	stato_precedente INT NOT NULL,
	stato INT NOT NULL,
	stato_dettaglio LONGVARCHAR,
	-- Tempi di creazione/esecuzione allarmi
	lasttimestamp_create TIMESTAMP NOT NULL,
	lasttimestamp_update TIMESTAMP,
	-- Informazioni generali (0=false/1=true)
	enabled INT NOT NULL,
	acknowledged INT NOT NULL,
	dettaglio_acknowledged LONGVARCHAR,
	periodo_tipo VARCHAR(255),
	periodo INT,
	mail_invia INT,
	-- Informazioni sull'invio di e-mail
	mail_invia_warning INT,
	mail_destinatari VARCHAR(65535),
	mail_subject VARCHAR(255),
	mail_body VARCHAR(65535),
	script_invoke INT,
	-- Informazioni sull'invocazione di script esterni
	script_invoke_warning INT,
	script_command VARCHAR(65535),
	script_args VARCHAR(65535),
	-- Filtro
	filtro_enabled BOOLEAN NOT NULL,
	filtro_protocollo VARCHAR(255),
	filtro_ruolo VARCHAR(255),
	filtro_porta VARCHAR(2000),
	filtro_tipo_fruitore VARCHAR(255),
	filtro_nome_fruitore VARCHAR(255),
	filtro_ruolo_fruitore VARCHAR(255),
	filtro_sa_fruitore VARCHAR(255),
	filtro_tipo_erogatore VARCHAR(255),
	filtro_nome_erogatore VARCHAR(255),
	filtro_ruolo_erogatore VARCHAR(255),
	filtro_tag VARCHAR(255),
	filtro_tipo_servizio VARCHAR(255),
	filtro_nome_servizio VARCHAR(255),
	filtro_versione_servizio INT,
	filtro_azione VARCHAR(65535),
	-- Raggruppamento
	group_enabled BOOLEAN NOT NULL,
	group_ruolo BOOLEAN NOT NULL,
	group_protocollo BOOLEAN NOT NULL,
	group_fruitore BOOLEAN NOT NULL,
	group_sa_fruitore BOOLEAN NOT NULL,
	group_id_autenticato BOOLEAN NOT NULL,
	group_token VARCHAR(65535),
	group_erogatore BOOLEAN NOT NULL,
	group_servizio BOOLEAN NOT NULL,
	group_azione BOOLEAN NOT NULL,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- check constraints
	CONSTRAINT chk_allarmi_1 CHECK (tipo_allarme IN ('ATTIVO','PASSIVO')),
	CONSTRAINT chk_allarmi_2 CHECK (filtro_ruolo IN ('delegata','applicativa','entrambi')),
	-- unique constraints
	CONSTRAINT uniq_allarmi_1 UNIQUE (nome),
	-- fk/pk keys constraints
	CONSTRAINT pk_allarmi PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX idx_allarmi_1 ON allarmi (nome);
CREATE INDEX idx_allarmi_2 ON allarmi (filtro_ruolo,filtro_porta);

ALTER TABLE allarmi ALTER COLUMN tipo_allarme SET DEFAULT 'ATTIVO';
ALTER TABLE allarmi ALTER COLUMN filtro_enabled SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_enabled SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_ruolo SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_protocollo SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_fruitore SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_sa_fruitore SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_id_autenticato SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_erogatore SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_servizio SET DEFAULT false;
ALTER TABLE allarmi ALTER COLUMN group_azione SET DEFAULT false;

CREATE TABLE allarmi_init_seq (id BIGINT);
INSERT INTO allarmi_init_seq VALUES (NEXT VALUE FOR seq_allarmi);



CREATE SEQUENCE seq_allarmi_parametri AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE allarmi_parametri
(
	param_id VARCHAR(255) NOT NULL,
	param_value LONGVARCHAR,
	-- fk/pk columns
	chk_param_id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	id_allarme BIGINT NOT NULL,
	-- unique constraints
	CONSTRAINT uniq_allarmi_param_1 UNIQUE (id_allarme,param_id),
	-- fk/pk keys constraints
	CONSTRAINT fk_allarmi_parametri_1 FOREIGN KEY (id_allarme) REFERENCES allarmi(id) ON DELETE CASCADE,
	CONSTRAINT pk_allarmi_parametri PRIMARY KEY (chk_param_id)
);

-- index
CREATE UNIQUE INDEX idx_allarmi_param_1 ON allarmi_parametri (id_allarme,param_id);
CREATE TABLE allarmi_parametri_init_seq (id BIGINT);
INSERT INTO allarmi_parametri_init_seq VALUES (NEXT VALUE FOR seq_allarmi_parametri);



CREATE SEQUENCE seq_allarmi_history AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE allarmi_history
(
	enabled INT NOT NULL,
	stato INT NOT NULL,
	stato_dettaglio VARCHAR(65535),
	acknowledged INT NOT NULL,
	timestamp_update TIMESTAMP NOT NULL,
	utente VARCHAR(255),
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	id_allarme BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_allarmi_history_1 FOREIGN KEY (id_allarme) REFERENCES allarmi(id) ON DELETE CASCADE,
	CONSTRAINT pk_allarmi_history PRIMARY KEY (id)
);

-- index
CREATE INDEX index_allarmi_history_1 ON allarmi_history (id_allarme,timestamp_update DESC);
CREATE INDEX index_allarmi_history_2 ON allarmi_history (timestamp_update);

ALTER TABLE allarmi_history ALTER COLUMN timestamp_update SET DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE allarmi_history_init_seq (id BIGINT);
INSERT INTO allarmi_history_init_seq VALUES (NEXT VALUE FOR seq_allarmi_history);



CREATE SEQUENCE seq_allarmi_notifiche AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE allarmi_notifiche
(
	data_notifica TIMESTAMP NOT NULL,
	old_stato INT NOT NULL,
	old_stato_dettaglio VARCHAR(65535),
	nuovo_stato INT NOT NULL,
	nuovo_stato_dettaglio VARCHAR(65535),
	history_entry LONGVARCHAR,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	id_allarme BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_allarmi_notifiche_1 FOREIGN KEY (id_allarme) REFERENCES allarmi(id) ON DELETE CASCADE,
	CONSTRAINT pk_allarmi_notifiche PRIMARY KEY (id)
);

-- index
CREATE INDEX index_allarmi_notifiche_1 ON allarmi_notifiche (data_notifica ASC);

ALTER TABLE allarmi_notifiche ALTER COLUMN data_notifica SET DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE allarmi_notifiche_init_seq (id BIGINT);
INSERT INTO allarmi_notifiche_init_seq VALUES (NEXT VALUE FOR seq_allarmi_notifiche);




-- govway
		  		




