CREATE SEQUENCE seq_statistiche_pdnd_tracing AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) CYCLE;

CREATE TABLE statistiche_pdnd_tracing
(
	data_tracciamento TIMESTAMP NOT NULL,
	data_registrazione TIMESTAMP,
	data_pubblicazione TIMESTAMP,
	pdd_codice VARCHAR(255) NOT NULL,
	csv VARBINARY(16777215),
	method VARCHAR(20),
	stato_pdnd VARCHAR(20) NOT NULL,
	tentativi_pubblicazione INT NOT NULL,
	force_publish BOOLEAN NOT NULL,
	stato VARCHAR(20),
	tracing_id VARCHAR(36),
	error_details VARCHAR(65535),
	history INT NOT NULL,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- check constraints
	CONSTRAINT chk_statistiche_pdnd_tracing_1 CHECK (method IN ('REPLACE','RECOVER','SUBMIT')),
	CONSTRAINT chk_statistiche_pdnd_tracing_2 CHECK (stato_pdnd IN ('WAITING','PENDING','OK','ERROR')),
	CONSTRAINT chk_statistiche_pdnd_tracing_3 CHECK (stato IN ('PUBLISHED','FAILED')),
	-- fk/pk keys constraints
	CONSTRAINT pk_statistiche_pdnd_tracing PRIMARY KEY (id)
);

-- index
CREATE INDEX INDEX_PDND_TRACING_ACTIVE ON statistiche_pdnd_tracing (pdd_codice,data_tracciamento DESC,history);

ALTER TABLE statistiche_pdnd_tracing ALTER COLUMN stato_pdnd SET DEFAULT 'WAITING';
ALTER TABLE statistiche_pdnd_tracing ALTER COLUMN tentativi_pubblicazione SET DEFAULT 0;
ALTER TABLE statistiche_pdnd_tracing ALTER COLUMN force_publish SET DEFAULT false;

CREATE TABLE statistiche_pdnd_tracing_init_seq (id BIGINT);
INSERT INTO statistiche_pdnd_tracing_init_seq VALUES (NEXT VALUE FOR seq_statistiche_pdnd_tracing);

-- constraint
ALTER TABLE statistiche DROP CONSTRAINT chk_statistiche_1;
ALTER TABLE statistiche ADD CONSTRAINT chk_statistiche_1 CHECK (tipo IN ('StatisticheOrarie','StatisticheGiornaliere','StatisticheSettimanali','StatisticheMensili','PdndGenerazioneTracciamento','PdndPubblicazioneTracciamento'));
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PdndGenerazioneTracciamento');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PdndPubblicazioneTracciamento');
