// ClientUILib base.js v1.0.0, Fri Jan 19 19:16:36 CET 2007

// TODO: Copyright (c) 2007, Denis Morozov (dmorozov@exadel.com)
// ...

if(!ClientUILib) {

var ClientUILib = {
	Version: '1.0.0',
	Name: 'ClientUILib',
	LibraryPath: './',	
	packages: [],
	load: function(showLog) {
	  // Check for Prototype JavaScript framework
	  
	  if((typeof Prototype=='undefined') || 
	     (typeof Element == 'undefined') || 
	     (typeof Element.Methods=='undefined') ||
	     parseFloat(Prototype.Version.split(".")[0] + "." +
	                Prototype.Version.split(".")[1]) < 1.5)
	     throw("ClientUILib requires the Prototype JavaScript framework >= 1.5.0");
	  	
	  // Check for Extend JavaScript library
//	  if((typeof Extend=='undefined') ||
//	  	Extend.VERSION < 1.1)
//	     throw("ClientUILib requires the Extend JavaScript library >= 1.1");

	  $A(document.getElementsByTagName("script")).findAll( function(s) {
	    return (s.src && s.src.match(/ClientUILib\.js(\?.*)?$/))
	  }).each( function(s) {
	    LibraryPath = s.src.replace(/ClientUILib\.js(\?.*)?$/,'');
	  });
	  
	  if(showLog) {
		  ClientUILogger.create("ClientUILogger");
		  this.startTime = (new Date()).getTime();
	  }
	  
	  this.initBrowser();
	},
 	include: function(libraryPackageName) {
		if(!this.packages)
			this.packages=[];
		if(!this.packages[libraryPackageName]) {
			this.packages[libraryPackageName] = true;
			var re = /\./g; // Replace all '.' in package name
			var packagePath = LibraryPath + libraryPackageName.replace(re, "/");
			document.write('<script type="text/javascript" src="' + packagePath + '.js"></script>');
		}
	},
	include2: function(libraryPackageName) {
		if(!this.packages)
			this.packages=[];
		if(!this.packages[libraryPackageName]) {
			this.packages[libraryPackageName] = true;
			var re = /\./g; // Replace all '.' in package name
			var packagePath = LibraryPath + libraryPackageName.replace(re, "/");
			var e = document.createElement("script");
		   	e.src = packagePath+".js";
		   	e.type="text/javascript";
		   	document.getElementsByTagName("head")[0].appendChild(e);		
		}
	},
	requireClass: function(libName) {
		// required class not included before
		if(!this.packages[libName]) {
			//this.include2(libName);
			ClientUILib.log(ClientUILogger.ERROR, "Library '" + libName + "' required!!!");
			throw("Package '" + libName + "' is required!");
		}
	},
	declarePackage: function(libName) {
		var pckg = null;
		var packages = $A(libName.split("."));
		packages.each( function(s) {
			if(pckg == null) {
//				pckg = eval(s);
				pckg = ClientUILib.customJSONEval(s);
			} else {
				if(!pckg[s]) pckg[s] = {};
				pckg = pckg[s];
			}
	  	});
	  	this.packages[libName] = true;
	},
	customJSONEval: function(data) {
		var result;

	    // Define callback
	    window.evalCallback = function(r){
	        result = r;
	    };
	
	    var newScript = document.createElement("script");
	    newScript.innerHTML = "evalCallback(" + data + ");";
	    /*
	     * // Add CSP nonce if relevant
	     * newScript.setAttribute("nonce", nonce);
	    */
	    document.head.appendChild(newScript);
	
	    // Now clean up DOM and global scope
	    document.head.removeChild(newScript);
	    delete window.evalCallback;
	
	    return result;
	},
	log: function(level, infoText) {
		if(ClientUILogger.isCreated){
			ClientUILogger.log(level, infoText);
		} else {
			switch(level) {
				case ClientUILogger.INFO: LOG.info(infoText); break; 	
				case ClientUILogger.ERROR: LOG.error(infoText); break; 	
				case ClientUILogger.WARNING: LOG.warn(infoText); break; 	
				default: LOG.a4jDebug(infoText);; 	
			}
		}
	},
	
	initBrowser: function() {
		var ua = navigator.userAgent.toLowerCase();
		/** @type Boolean */
		this.isOpera = (ua.indexOf('opera') > -1);
	   	/** @type Boolean */
		this.isSafari = (ua.indexOf('webkit') > -1);
	   	/** @type Boolean */
		this.isIE = (window.ActiveXObject);
	   	/** @type Boolean */
		this.isIE7 = (ua.indexOf('msie 7') > -1);
	   	/** @type Boolean */
		this.isIE8 = (ua.indexOf('msie 8') > -1);
	   	/** @type Boolean */
		this.isGecko = !this.isSafari && (ua.indexOf('gecko') > -1);
		
		if(ua.indexOf("windows") != -1 || ua.indexOf("win32") != -1){
		    /** @type Boolean */
		    this.isWindows = true;
		}else if(ua.indexOf("macintosh") != -1){
			/** @type Boolean */
		    this.isMac = true;
		}
		if(this.isIE && !this.isIE7){
	        try{
	            document.execCommand("BackgroundImageCache", false, true);
	        }catch(e){}
	    }
	}	
};

var ClientUILogger = {
	// log level
	INFO: 		1,
	WARNING: 	2,
	ERROR: 		3,
	EVENT:		4, //KAW EVENT level added to trace events
	ALERT:		5, //KAW ALERT level to stop executing script
	hEnabledLevels: {
		1: true,
		2: true,
		3: true,
		4: true,
		5: false
	},	
	// flag logger is initialized
	isCreated: false,
	width: 460,
	height: 600,
	top: 0,
	left: 750,
	bLoggingEnabled: true,
	create: function() {
		this.mainDiv = $(document.createElement("div"));
		this.mainDiv.setStyle({border: '1px black solid',
			position: 'absolute',padding: '1px'});
		this.logElement = $(document.createElement("div"));
		this.logElement.setStyle({overflow: 'auto', whiteSpace: 'nowrap'});
		this.buttonsContainer = $(document.createElement("div"));
		
		var clearDiv = this.buttonClear = $(document.createElement('div'));
		clearDiv.setStyle({width: 120 + 'px', height: 25 + 'px',
			border: '1px black solid'});
		clearDiv.innerHTML = 'Clear';
		
		var toggleLoggingDiv = this.buttonToggleLogging = $(document.createElement('div'));
		toggleLoggingDiv.setStyle({width: 120 + 'px', height: 25 + 'px',
			border: '1px black solid', position: 'relative',
			top: '-27px', left: '122px'
		});
		toggleLoggingDiv.innerHTML = 'Logging '+this.isLoggingEnabled();
		
		var toggleAlertDiv = this.buttonToggleAlert = $(document.createElement('div'));
		toggleAlertDiv.setStyle({width: 120 + 'px', height: 25 + 'px',
			border: '1px black solid', position: 'relative',
			top: '-54px', left: '244px'
		});
		toggleAlertDiv.innerHTML = 'Alert '+this.isLevelEnabled(ClientUILogger.ALERT);		
		
		this.buttonsContainer.appendChild(clearDiv);
		this.buttonsContainer.appendChild(toggleLoggingDiv);
		this.buttonsContainer.appendChild(toggleAlertDiv);
		this.mainDiv.appendChild(this.logElement);
		this.mainDiv.appendChild(this.buttonsContainer);		
		
		this.eventClearClicked = this.onClearClick.bindAsEventListener(this);
		this.eventToggleLoggingClicked = this.onToggleLoggingClick.bindAsEventListener(this);
		this.eventToggleAlertClicked = this.onToggleAlertClick.bindAsEventListener(this);
		Event.observe(toggleLoggingDiv, 'click', ClientUILogger.eventToggleLoggingClicked);
		Event.observe(toggleAlertDiv, 'click', ClientUILogger.eventToggleAlertClicked);
		Event.observe(clearDiv, 'click', ClientUILogger.eventClearClicked);
		Event.observe(window, 'load', ClientUILogger.init);
		Event.observe(window, 'resize', ClientUILogger.resizeWindow);
		
		this.isCreated = true;
	},
	onToggleAlertClick: function() {
		this.toggleLevel(ClientUILogger.ALERT);
		this.buttonToggleAlert.innerHTML = 'Alert '+this.isLevelEnabled(ClientUILogger.ALERT);
	},
	onToggleLoggingClick: function(event) {
		this.toggleLogging();
		this.buttonToggleLogging.innerHTML = 'Logging '+this.isLoggingEnabled();
	},
	onClearClick: function(event) {
		Event.stop(event);
		this.logElement.innerHTML = '';
	},
	init: function() {
		if(ClientUILogger.mainDiv)
			document.body.appendChild(ClientUILogger.mainDiv);
		ClientUILogger.show();
	},
	resizeWindow: function() {
		ClientUILogger.show();
	},
	show: function() {
		if(this.logElement) {
			Element.show(this.mainDiv);
			this.mainDiv.setStyle({width: this.width + 'px',
				height: this.height + 'px', 
				top: this.top + 'px',
				left: this.left+ 'px',
				zIndex: '1000'});
			this.logElement.setStyle({width: '100%', height: '90%'});
			this.buttonsContainer.setStyle({width: '100%', height: '10%'});			
			//this.logElement.setStyle({top: (this.getWindowHeight() - this.height - 10) + 'px'});
			//this.logElement.setStyle({top: 10 + 'px'});
			//this.logElement.setStyle({left: (this.getWindowWidth() - this.width - 10) + 'px'});
			//KAW changed logger display place
		}
	},
	isLevelEnabled: function(level) {
		return this.hEnabledLevels[level];
	},
	isLoggingEnabled: function() {
		return this.bLoggingEnabled;
	},
	toggleLogging: function() {
		this.bLoggingEnabled = !this.bLoggingEnabled;
	},
	toggleLevel: function(level) {
		this.hEnabledLevels[level] = !this.hEnabledLevels[level];
	},	
	log: function(level, infoText) {
		var bIgnoreLog = !this.isLoggingEnabled() || !this.isLevelEnabled(level);
		if (bIgnoreLog) { 
			//PREMATURE RETURN no logging required
			return;
		}
		
		if (level == ClientUILogger.ALERT) {
			alert(infoText);
		}else{
			var msg = $(document.createElement("div"));
			this.logElement.appendChild(msg);
			msg.setStyle({width: '100%'});
			
			var font = "bold normal bold 10pt Arial";
			var fontColor = "red";

			switch(level) {
				case ClientUILogger.INFO: 
					fontColor = "black";
					font = "normal normal normal 10pt Arial";
					break;
				case ClientUILogger.WARNING: 
					fontColor = "blue";
					font = "italic normal normal 10pt Arial";
					break;
				case ClientUILogger.ERROR: 
					fontColor = "red";
					font = "normal normal bold 10pt Arial";
					break;
				case ClientUILogger.EVENT: 
					fontColor = "green";
					font = "normal normal bold 10pt Arial";
					break;
				default:
					infoText = "UNRESOLVED: level=" + level + ", msg=" + infoText;
			}
			msg.setStyle({font: font});
			msg.setStyle({color: fontColor});
			msg.appendChild(document.createTextNode("> " + infoText));
			
			this.logElement.scrollTop = this.logElement.scrollHeight;			
		}
	},
	getWindowWidth: function(){
	    var innerWidth;
		  if (navigator.appVersion.indexOf('MSIE')>0) {
			  innerWidth = document.body.clientWidth;
	    } else {
			  innerWidth = window.innerWidth;
	    }
	    return innerWidth;	
	},
	getWindowHeight: function(){
	    var innerHeight;
		  if (navigator.appVersion.indexOf('MSIE')>0) {
			  innerHeight = document.body.clientHeight;
	    } else {
			  innerHeight = window.innerHeight;
	    }
	    return innerHeight;	
	}	
};

ClientUILib.load(false); //KAW debugging OFF

// declare predefined packages
var ClientUI = {
	controls: {},
	layouts: {}
};

// Some helper functions\
if(!ClientUILib.isIE){
	HTMLElement.prototype.click = function() {
		var evt = this.ownerDocument.createEvent('MouseEvents');
		evt.initMouseEvent('click', true, true, this.ownerDocument.defaultView, 1, 0, 0, 0, 0, false, false, false, false, 0, null);
		this.dispatchEvent(evt);
	}
};

// Usage: Event.onReady(callbackFunction);
Object.extend(Event, {
	_domReady : function() {
		if (arguments.callee.done) return;
		arguments.callee.done = true;
		 
		if (Event._timer) clearInterval(Event._timer);
		
		Event._readyCallbacks.each(function(f) { f() });
		Event._readyCallbacks = null;
	},
	onReady : function(f) {
		if (!this._readyCallbacks) {
			var domReady = this._domReady;
		
			if (domReady.done) return f();
		
			if (document.addEventListener)
				document.addEventListener("DOMContentLoaded", domReady, false);
			if (/WebKit/i.test(navigator.userAgent)) {
				this._timer = setInterval(function() {
					if (/loaded|complete/.test(document.readyState)) domReady();
				}, 10);
			}
			Event.observe(window, 'load', domReady);
			Event._readyCallbacks = [];
		}
		Event._readyCallbacks.push(f);
	}
});

};
var Utils = {
	
	DOM: {
		copyAttributes : function(target, source, opts) {

			//LOG.debug("copyAttributes");
			var attrs = source.attributes;
			
			var exclusions = (opts && opts.exclude) ? opts.exclude : [];
			
			for(var i = 0 ; i < attrs.length; i++) {
			
				var attributeNode = attrs[i];
				var nodeName = attributeNode.nodeName;
				var nodeValue = attributeNode.nodeValue;
				
				var shouldCheckAttribute = 
					nodeValue && 
					nodeValue.length > 0 && 
					exclusions.indexOf(nodeName) < 0;
				
				if (ClientUILib.isIE) {
					shouldCheckAttribute &= attributeNode.specified;
				}
				
				if(shouldCheckAttribute) {
					
					//LOG.debug("Copying attribute " + attributeNode.nodeName + "=" + attributeNode.nodeValue);
					
					var newAttributeNode = 
						document.createAttribute(nodeName);
					
					newAttributeNode.nodeValue = attributeNode.nodeValue;
					target.setAttributeNode(newAttributeNode);
				}
				
			}
			//LOG.debug("/copyAttributes");
		},
		
		replaceNode : function(id, request) {
			var target = document.getElementById(id);
			var src = request.getElementById(id);
	
			if(target && src) {
				var cells = target.cells;
				for(var i = 0; i < cells.length; i++) {
					Utils.DOM.Event.removeListeners(cells[i]);
				}
				
				if (ClientUILib.isIE) {
					var s = String();
					var newOuterXml = "<table><tbody>" + src.xml + "</tbody></table>";
					var newNode = document.createElement("DIV");

					newNode.innerHTML = newOuterXml;

					var imported = newNode.firstChild.firstChild.firstChild;
					target.parentNode.replaceChild(imported, target);;
					return imported;
					
				} else if (ClientUILib.isGecko){
					//Mozill family
					var theDoc = document;
				
					Utils.DOM._clearAttributes(target);
					Utils.DOM.copyAttributes(target, src);

					target.innerHTML = src.innerHTML;//nnerHTML.join("");
					return target;
				} else {
					//Fall back to DOM, and cross the fingers
					src = document.importNode(src, true);
					target.parentNode.replaceChild(src, target);
					return src; 
				}
			}
			else {
				if(!target)
					ClientUILib.log(ClientUILogger.ERROR, "DOM Element with id " + id + " not found for update.");
				if(!src) {
					ClientUILib.log(ClientUILogger.ERROR, "RESPONSE Element with id " + id + " not found for update.");
					
					// cleanup destination
					if(target) {
						for(var i=0; i<target.cells.length; i++) {
							target.cells[i].innerHTML = "";
						}
					}
				}
			}
		},
		
		_clearAttributes : function(node) {

			var attrs = node.attributes;
			if (node.clearAttributes) {
				node.clearAttributes();
			} else {
				while(node.attributes.length > 0) {
					node.removeAttributeNode(node.attributes[0]);
				}
			}
		},
		
		_formatNode : function(node) {
			
			var sb = new StringBuilder();
			
			sb.append("<").append(node.nodeName);
			for (var i = 0; i < node.attributes.length; i++) {
				var attr = node.attributes[i];
				if (attr.specified) {
					sb
						.append(" ")
						.append(attr.nodeName)
						.append("=\"")
						.append(attr.nodeValue)
						.append("\" ");
				}
			}
			
			sb.append("/>");
			
			return sb.toString();
			
		},
		
		Event: {
			
			/**
			 * cache listeners in element to kill them all on element ajax replace
			 * @param {Object} element
			 * @param {Object} event
			 * @param {Object} handler
			 * @param {Object} useCapture
			 */
			observe : function (element, event, handler, useCapture) {
				if (true) {
					if (!element._listeners) {
						element._listeners = [];
					}
					
					element._listeners[element._listeners.length] = 
						{
							event: event,
							handler: handler,
							useCapture: useCapture
						};
				}
				Event.observe(element, event, handler, useCapture);
			},
			
			stopObserving : function(element, event, handler, useCapture) {
				
				if(element._listeners) {
					element._listeners = 
						element._listeners.reject(
							function(obj) {
								return obj.event == event 
									&& obj.handler == handler 
									&& obj.useCapture == useCapture;
							}
						);
				}
				
				Event.stopObserving(element, event, handler, useCapture);
				
			}, 
			
			removeListeners : function(element) {
				if (element._listeners) {
					var l = element._listeners.length;
					for(var i = 0; i < l; i++) {
						var listener = element._listeners[i];
						Event.stopObserving(
							element, 
							listener.event, 
							listener.handler, 
							listener.useCapture);
					}
					
					element._listeners = null;
				}
			}	
		}
	},
	
	AJAX : {
		updateRows: function(options,request,grid,clientid, callbacks, callbacksPost){
			var localOptions = options;
			var rowCount = grid.getBody().templNormal.getElement().rows.length;
			var startRow = localOptions.startRow;
			var count = localOptions.count;
			var rowindex, i, el;
			var dataModel = grid.dataModel;
			var baseid = clientid;
			var suffixs = [":n:"];
			if (($(baseid+":f")).rows.length) {
				suffixs = [":f:", ":n:"];
			}
			var countForUpdate = 0;
			var rowsForUpdate = [];
			
			for(i=0; i<count; i++) {
				rowindex = startRow + i;
				if(rowindex >= rowCount){
					 rowindex -= rowCount;
				}
				suffixs.unbreakableEach(
					function(suffix) {
						var id = [baseid,suffix,rowindex].join("");
						var row = Utils.DOM.replaceNode(id, request);
						
						if (callbacks) {
							// just suspend operation for future
							if(!rowsForUpdate[i]) rowsForUpdate[i] = {};
							rowsForUpdate[i][suffix] = {index : rowindex, row : row};
							countForUpdate++;
						}
					} 
				);
			}
			if (ClientUILib.isIE7 || ClientUILib.isIE8) {
				setTimeout(function()  {
					var scrollElement = grid.getBody().scrollBox.getElement();
					var scrollTop = scrollElement.scrollTop;
					if (!scrollTop) {
						scrollElement.scrollTop++;
					} else {
						scrollElement.scrollTop--;
					}
					scrollElement.scrollTop = scrollTop;
				}, 50);
			} 
			
			if (callbacks && countForUpdate>0) {
				// process suspended processing
				setTimeout(function(){
					for(var i=0; i<count; i++) {
						callbacks.unbreakableEach(
							function(callback) {
								if(rowsForUpdate[i]) {
									suffixs.unbreakableEach(
										function(suffix) {
											if(rowsForUpdate[i][suffix].row) {
												callback.call(grid, rowsForUpdate[i][suffix]);
											}
										} 
									);
								}
							}
						);
					}
					
					if(callbacksPost) {
						callbacksPost.unbreakableEach(
							function(callback) {
								callback.call(grid);
							}
						);
					}
				}, 100);
			}
	
			grid.getBody()._onDataReady(localOptions);
		}	
	}
};
/*
var _cAtt = Utils.DOM._clearAttributes;
Utils.DOM._clearAttributes = function() {
	return;
	var d1 = new Date().getTime();
	_cAtt.apply(Utils.DOM, arguments);
	var d2 = new Date().getTime();
	ClientUILib.log(ClientUILogger.INFO, "Utils.DOM._clearAttributes " + (d2 - d1) + "ms");
};
var cAtt = Utils.DOM._clearAttributes;
Utils.DOM.copyAttributes = function() {
	return;
	var d1 = new Date().getTime();
	cAtt.apply(Utils.DOM, arguments);
	var d2 = new Date().getTime();
	ClientUILib.log(ClientUILogger.INFO, "Utils.DOM.copyAttributes " + (d2 - d1) + "ms");
};
*/
Utils.execOnLoad = function(func, condition, timeout) {
	if (condition()) {
		func();		
	} else {
		var intervalId = setInterval(
			function() {
				if (condition()) {
					func();
					clearInterval(intervalId);
				}
			},
			timeout
		);
	}
	
	return intervalId;
};
Utils.Condition = {
	ElementPresent : function(element) {
		return function () {
			var el = $(element);
			return el && el.offsetHeight > 0;
		};
	}
};

Utils.trace = function(s) {
	LOG.info(s + ": " + (new Date().getTime()- this._d) + "    ");
	//window.status = s + ": " + (new Date().getTime()- this._d) + "    " + window.status;
	this._d = new Date().getTime();
};

Utils.getRule = function (className) {
	var rule = null;
	var sheets = document.styleSheets;
	var lcClassName = className.toLowerCase();
	
	for (var j = 0; !rule && j < sheets.length; j++) {
		var rules = sheets[j].cssRules ? sheets[j].cssRules: sheets[j].rules;
		for (var i = 0; !rule && i < rules.length; i++) {
			if (rules[i].selectorText && rules[i].selectorText.toLowerCase() == lcClassName) {
				rule = rules[i];
			}
		}
	}
	return rule;			
};

Array.prototype.unbreakableEach = function(f) {
	for (var i = 0; i < this.length; i++) {
		f(this[i], i);
	}
};/*
 * TODO: Copyright (c) 2007 Denis Morozov <dmorozov@exadel.com>
 *
 * ...
 */
ClientUILib.declarePackage("ClientUI.common.utils.StringBuilder");

/*
/* sbuilder.js - Helper class to improve strings concatenation perfomance 
 * by Denis Morozov <dmorozov@exadel.com> distributed under the BSD license. 
 *
 * Usage:
 * var sb = new StringBuilder();
 * sb.append("String 1").append("String 2");
 * sb.append("String 3");
 * var str = sb.toString();
 */
StringBuilder = Class.create({
	
	initialize: function(str) {
		this._string = null;
		this._current = 0;
		this._parts = [];
		this.length = 0;
		
		if(str != null)
			this.append(str);
	},
	append: function (str) {
		// append argument
		//this.length += (this._parts[this._current++] = String(str)).length;
		this._parts.push(String(str));
		
		// reset cache
		this._string = null;
		return this;
	},
	
	toString: function () {
		if (this._string != null)
			return this._string;
		
		var s = this._parts.join("");
		this._parts = [s];
		this._current = 1;
		this.length = s.length;
		
		return this._string = s;
	},
	
	clean: function(str) {
		this.initialize();
	}
});

Object.extend(StringBuilder.prototype, {
	length: 	0,
	
	// private
	_current:	0,
	_parts:		[],
	_string: 	null	// used to cache the string
});
/**
 * Validators.js		Date created: 14.04.2007
 * Copyright (c) 2007 Exadel Inc.
 * @author Denis Morozov <dmorozov@exadel.com>
 */
 
var Validators = {
	/**
	 * Internet Explorer holds references to objects that are not actually javascript objects. So if we use the 
	 * objects in javascript it will give error. But the typeof operator identifies them as javascript objects( problem!!!). 
	 * Here we can use the isIEObject() function to identify those objects.
	 */
	isIEObject: function(a) {
		return this.isObject(a) && typeof a.constructor != 'function';
	},

	/**
	 * This function returns true if a is an array, meaning that it was produced by the Array constructor or by 
	 * the [ ] array literal notation.
	 */
	isArray: function(a) {
		return this.isObject(a) && a.constructor == Array;
	},
 
	/**
	 * This function returns true if a is one of the Boolean values, true or false.
	 */
	isBoolean: function(a) {
		return typeof a == 'boolean';
	},
	
	getBoolean: function(val, defVal) {
		if(this.isBoolean(val))
			return val;
		if(val == "true") return true;
		else if(val == "false") return false;
		
		return defVal;
	},

	/**
	 * This function returns true if a is an object or array or function containing no enumerable members.
	 */
	isEmpty: function(o) {
		if (this.isObject(o)) {
           for (var i in o) {
                return false;
           }
		}
		else if(this.isString(o) && o.length > 0) {
			return false;
		}
		
		return !this.IsNumber(o);
	},

	/**
	 * This function returns true if a is a function. Beware that some native functions in IE were made to look 
	 * like objects instead of functions. This function does not detect that.Netscape is better behaved in this regard.
	 */
	isFunction: function(a) {
		return typeof a == 'function';
	},

	/**
	 * This function returns true if a is the null value.
	 */
	isNull: function(a) {
		return typeof a == 'object' && !a;
	},

	/**
	 * This function returns true if <code>data</code> is a finite number. It returns false if <code>data</code> is NaN or Infinite.
	 */
	IsNumber: function(data) {
		if(typeof data == 'number' && isFinite(data)) {
			return true;
		}
		
		// if it is a string that contains a number
		var re = /(^-?[1-9](\d{1,2}(\,\d{3})*|\d*)|^0{1})$/;
		if ( re.test(data) ) {
			return true;
		}
		return false;
	},
	IsFormattedNumber: function(data) {
		// Regular expression should match number with commas or not
		//1. ^-? <-- '-' is optional at the beginning
		//2. \d{1,3} <-- with or without comma, first 3 digits
		//3. \d{1,3}(\,\d{3})* <-- with comma, at least one digit with max of three before repeating like ',ddd'
		//4. \d+ <-- without comma, match any number of integer(shouldn't be though)
		var re = /^-?(\d{1,3}|\d{1,3}(\,\d{3})*|\d*)$/g;
		if ( ! re.test(data) ) {
			return false;
		}
		return true;		
	},

	/**
	 * This function returns true if a is an object, array, or function. It returns false if a is a string, 
	 * number, Boolean, null, or undefined.
	 */
	isObject: function(a) {
		return (typeof a == 'object' && !!a) || this.isFunction(a);
	},

	/**
	 * This function returns true if a is a string.
	 */
	isString: function(a) {
		return typeof a == 'string';
	},

	/**
	 * This function returns true if a is the undefined value. You can get the undefined value from an uninitialized 
	 * variable or from an object's missing member.
	 */
	isUndefined: function(a) {
		return typeof a == 'undefined';
	}
};/**
 * Box.js		Date created: 6.04.2007
 * Copyright (c) 2007 Exadel Inc.
 * @author Denis Morozov <dmorozov@exadel.com>
 */
ClientUILib.declarePackage("ClientUI.common.box.Box");


/*
 * Base class for all ui controls 
 *
 * TODO: description of control 
 *
 * TODO: usage description
 * Usage: 
 *  ClientUILib.declarePackage("ClientUI.common");
 *  ClientUILib.requireClass("ClientUI.common.box.Box");
 * 	var ClientUI.MyControl = Class.create({
 * 		CLASSDEF : {
 * 			name:  'ClientUI.MyControl',
 * 			parent: ClientUI.common.box.Box
 * 		}, 		
 *		initialize:function() {
 *			this.parentClass().constructor().call(this)
 *			alert("A new " + this.getClass().className + " was created")
 *		}				
 *	})
 */
ClientUI.common.box.Box = Class.create({

	initialize: function(element, parentElement, dontUpdateStyles) {
		this.element = $(element);
		if(!this.element) {
			this.element = $(document.createElement("div"));
			if($(parentElement)) {
      			$(parentElement).appendChild(this.element);
			}
      		else {
	      		document.body.appendChild(this.element);
      		}
      	}
		//http://jira.jboss.com/jira/browse/RF-2068
		//this.element.wrapper = this;
		if(!this.element.parentNode && $(parentElement)) {
			$(parentElement).appendChild(this.element);
		}

      	if(!this.element.id) {
			this.element.id = "ClientUI_Box" + ClientUI_common_box_Box_idGenerator++;
		}
		if(!dontUpdateStyles) {
	      	this.element.setStyle({overflow: 'hidden'});
	      	this.element.setStyle({whiteSpace: 'nowrap'});
		}
	},
	
	setParent: function(newParent) {
		if(this.element.parentNode) {
			this.element.parentNode.removeChild(this.element);
		}
		if(newParent) {
			if(newParent.getElement) {
				newParent = newParent.getElement();
			}
			$(newParent).appendChild(this.element);			
		}
		return this;
	},
	getElement: function() {
		return this.element;
	},
	getHeight: function() {
		var el = this.getElement();
		if(el.tagName.toLowerCase() != "body") {
			var h = el.offsetHeight;
			return h>0 ? h : (this.element.boxHeight ? parseInt(this.element.boxHeight) : 0);
		}

		if (self.innerHeight) { // all except Explorer
			return self.innerHeight;
		}
		else if (document.documentElement && document.documentElement.clientHeight) {
			// Explorer 6 Strict Mode
			return document.documentElement.clientHeight;
		}
		else if (document.body) { // other Explorers
			return document.body.clientHeight;
		}
	},
	isModified: false,
	setHeight: function(newHeight) {
		this.element.boxHeight = newHeight;
		if(Validators.IsNumber(newHeight)) {
			if(newHeight<0) newHeight = 0;
			newHeight += "px";	
		}
		this.element.setStyle({height: newHeight});
		isModified = true;
		return this;
	},
	getWidth: function() {
		var el = this.getElement();
		if(el.tagName.toLowerCase() != "body") {
			var w = el.offsetWidth;
			return w>0 ? w : (this.element.boxWidth ? parseInt(this.element.boxWidth) : 0);
		}
			
		if (self.innerHeight) {// all except Explorer
			return self.innerWidth;
		}
		else if (document.documentElement && document.documentElement.clientHeight) {
			// Explorer 6 Strict Mode
			return document.documentElement.clientWidth;
		}
		else if (document.body) { // other Explorers
			return document.body.clientWidth;
		}			
	},
	setWidth: function(newWidth) {
		this.element.boxWidth = newWidth;
		if(Validators.IsNumber(newWidth)) {
			if(newWidth<0) newWidth = 0;
			newWidth += "px";	
		}
		this.element.setStyle({width: newWidth});
		isModified = true;
		return this;
	},
	moveToX: function(x) {
		if(Validators.IsNumber(x)) {x += "px";}
		this.getElement().setStyle({left: x});
		isModified = true;
		return this;		
	},
	moveToY: function(y) {
		if(Validators.IsNumber(y)) {y += "px";}
		this.getElement().setStyle({top: y});
		isModified = true;
		return this;
	},
	moveTo: function(x, y) {
		this.moveToX(x);
		this.moveToY(y);
		return this;
	},
	hide: function() {
		Element.hide(this.element);
		isModified = true;
		return this;
	},
	show: function() {
		Element.show(this.element);
		isModified = true;
		return this;
	},
	updateLayout: function() {
		isModified = false;
		return this;
	},
	getViewportWidth: function() {
		if(this.getElement().tagName.toLowerCase() != "body") {
			var width = 0;
			if( this.getElement().clientWidth ) {
			    width = this.getElement().clientWidth;
			}
			else if( this.getElement().innerWidth ) {
			    width = this.getElement().innerWidth - getScrollerWidth();
			}
			  
			if(ClientUILib.isGecko) {
			  	width -= this.getPadding("lr");
			}
			return width;
		}
		
		return this.getWidth();
	},
	getViewportHeight: function() {
		if(this.getElement().tagName.toLowerCase() != "body") {
			var height = 0;
			if( this.getElement().clientHeight ) {
			    height = this.getElement().clientHeight;
			}
			else if( this.getElement().innerHeight ) {
			    height = this.getElement().innerHeight - getScrollerWidth();
			}
			  
			if(ClientUILib.isGecko) {
			  	height -= this.getPadding("tb");
			}
			return height;
		}
		return this.getHeight();
	},	
	/**
     * Gets the width of the border(s) for the specified side(s)
     * @param {String} side Can be t, l, r, b or any combination of those to add multiple values. For example, 
     * passing lr would get the border (l)eft width + the border (r)ight width.
     * @return {Number} The width of the sides passed added together
     */
    getBorderWidth : function(side){
        return this.getStyles(side, this.borders);
    },
    
    /**
     * Gets the width of the padding(s) for the specified side(s)
     * @param {String} side Can be t, l, r, b or any combination of those to add multiple values. For example, 
     * passing lr would get the padding (l)eft + the padding (r)ight.
     * @return {Number} The padding of the sides passed added together
     */
    getPadding : function(side){
        return this.getStyles(side, this.paddings);
    },	
	getStyles : function(sides, styles){
        var val = 0;
        for(var i = 0, len = sides.length; i < len; i++){
             var w = parseInt(this.getElement().getStyle(styles[sides.charAt(i)]), 10);
             if(!isNaN(w)) val += w;
        }
        return val;
    },
	makeAbsolute: function(keepPos) {
		if(keepPos) {
			Position.absolutize(this.getElement());	
		}
		else {
			this.getElement().setStyle({position: 'absolute'});
		}
		return this;
	},
	getX: function() {
		return this.getElement().offsetLeft;
	},
	getY: function() {
		return this.getElement().offsetTop;
	},
	setStyle: function(style) {
		this.getElement().setStyle(style);
		return this;
	},
	
	borders: {l: 'border-left-width', r: 'border-right-width', t: 'border-top-width', b: 'border-bottom-width'},
	paddings: {l: 'padding-left', r: 'padding-right', t: 'padding-top', b: 'padding-bottom'},
	margins: {l: 'margin-left', r: 'margin-right', t: 'margin-top', b: 'margin-bottom'}
	
});

if(!ClientUI_common_box_Box_idGenerator) {
var ClientUI_common_box_Box_idGenerator = 0;
};/**
 * InlineBox.js		Date created: 6.04.2007
 * Copyright (c) 2007 Exadel Inc.
 * @author Denis Morozov <dmorozov@exadel.com>
 */
ClientUILib.declarePackage("ClientUI.common.box.InlineBox");

ClientUILib.requireClass("ClientUI.common.box.Box");

/**
 * Base class that wrap work with inline blocks like span
 */
ClientUI.common.box.InlineBox = Class.create(ClientUI.common.box.Box, {

	initialize: function($super, element, parentElement, dontUpdateStyles) {
		if(!element) {
			element = $(document.createElement("span"));
			if($(parentElement)) {
      			$(parentElement).appendChild(element);
			}
      		else {
	      		document.body.appendChild(element);
      		}
      	}		
      	if(!element.id) {
			element.id = "ClientUI_InlineBox" + ClientUI_common_box_InlineBox_idGenerator++;
		}
		
		$super(element, parentElement, dontUpdateStyles);
		
		// additional styles
		if(!dontUpdateStyles) {
			this.element.setStyle({display: 'block'});	
		}
	}
});

if(!ClientUI_common_box_InlineBox_idGenerator) {
	var ClientUI_common_box_InlineBox_idGenerator = 0;
};/**
 * ScrollableBox.js		Date created: 6.04.2007
 * Copyright (c) 2007 Exadel Inc.
 * @author Denis Morozov <dmorozov@exadel.com>
 */
ClientUILib.declarePackage("ClientUI.common.box.ScrollableBox");

ClientUILib.requireClass("ClientUI.common.box.Box");

/**
 * This class target to manage scrollable box object.
 */
ClientUI.common.box.ScrollableBox = Class.create(ClientUI.common.box.Box, {

	//Constructor
	initialize: function($super, element, parentElement) {
		$super(element, parentElement);
		this.element.setStyle({overflow: 'auto'});
		
		this.eventOnScroll = this.scrollContent.bindAsEventListener(this);
		Event.observe(this.element, 'scroll', this.eventOnScroll);
	},
	scrollContent: function(event) {
		this.updateScrollPos();
	},
	updateScrollPos: function() {
		this.timer = null;
		
		// process horizontal scrolling
		if(this.scrollLeft!==this.getViewportScrollX()) {
			this.scrollLeft = this.getViewportScrollX();
			this.element.fire("grid:onhcroll", {pos:this.getViewportScrollX()});
		}
		
		// process vertical scrolling		
		if(this.scrollTop!==this.getViewportScrollY()) {
			this.scrollTop = this.getViewportScrollY();
			this.element.fire("grid:onvcroll", {pos:this.getViewportScrollY()});
		}
	},
	updateLayout: function($super) {
		// NOTE: not implemented in this class
		$super();
	},
	getViewportScrollX: function() {
		var scrollX = 0;
		if( this.getElement().scrollLeft ) {
			scrollX = this.getElement().scrollLeft;
		}
		else if( this.getElement().pageXOffset ) {
			scrollX = this.getElement().pageXOffset;
		}
		else if( this.getElement().scrollX ) {
			scrollX = this.getElement().scrollX;
		}
		return scrollX;
	},
	getViewportScrollY: function() {
		var scrollY = 0;
		if( this.getElement().scrollTop ) {
			scrollY = this.getElement().scrollTop;
		}
		else if( this.getElement().pageYOffset ) {
			scrollY = this.getElement().pageYOffset;
		}
		else if( this.getElement().scrollY ) {
			scrollY = this.getElement().scrollY;
		}
		return scrollY;
	},
	getScrollerWidth: function() {
		if(this.scrollerWidth && this.scrollerWidth > 0)
			return this.scrollerWidth;
			
	    var scr = null;
	    var inn = null;
	    var wNoScroll = 0;
	    var wScroll = 0;
	
	    // Outer scrolling div
	    scr = document.createElement('div');
	    scr.style.position = 'absolute';
	    scr.style.top = '-1000px';
	    scr.style.left = '-1000px';
	    scr.style.width = '100px';
	    scr.style.height = '50px';
	    // Start with no scrollbar
	    scr.style.overflow = 'hidden';
	
	    // Inner content div
	    inn = document.createElement('div');
	    inn.style.width = '100%';
	    inn.style.height = '200px';
	
	    // Put the inner div in the scrolling div
	    scr.appendChild(inn);
	    // Append the scrolling div to the doc
	    document.body.appendChild(scr);
	
	    // Width of the inner div sans scrollbar
	    wNoScroll = inn.offsetWidth;
	    // Add the scrollbar
	    scr.style.overflow = 'auto';
	    // Width of the inner div width scrollbar
	    wScroll = inn.offsetWidth;
	
	    // Remove the scrolling div from the doc
	    document.body.removeChild(
	        document.body.lastChild);
	
	    // Pixel width of the scroller
	    this.scrollerWidth = (wNoScroll - wScroll);
	    return this.scrollerWidth || 0;
	}	
});/**
 * Substrate.js		Date created: 21.04.2007
 * Copyright (c) 2007 Exadel Inc.
 * @author Denis Morozov <dmorozov@exadel.com>
 */
ClientUILib.declarePackage("ClientUI.common.box.Substrate");

ClientUILib.requireClass("ClientUI.common.box.Box");

/**
 * Base class that wrap work with inline blocks like span
 */
ClientUI.common.box.Substrate = Class.create(ClientUI.common.box.Box, {

	initialize: function($super, element, parentElement, dontUpdateStyles) {
		if(!element) {			
			var fakeElement = $(document.createElement("div"));
			fakeElement.innerHTML = '<iframe id="'+'ClientUI_Substrate' + (ClientUI_common_box_Substrate_idGenerator++) +'" src="javascript:\'\'" scrolling="no" frameborder="0" style="filter:Alpha(opacity=0);position:absolute;top:0px;left:0px;display:block"></iframe>';
			element = $(fakeElement.getElementsByTagName("iframe")[0]);
			fakeElement.removeChild(element);
      	}		
		
		$super(element, parentElement, dontUpdateStyles);
		
		// additional styles
		if(!dontUpdateStyles) {
		}
	}
});

if(!ClientUI_common_box_Substrate_idGenerator) {
	var ClientUI_common_box_Substrate_idGenerator = 0;
};